/*					
 * M1_Params.h					
 *					
 *  Created on: Jul 15, 2015					
 *      Author: B46639					
 */					
					
#ifndef M1_PARAMS_H_					
#define M1_PARAMS_H_					
					
/* Motor basic parameters */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define	M1_STATOR_R		0.55	 /* [ohm] */	
#define	M1_LD_INDUCTANCE		0.0012	 /* [Henry] */	
#define	M1_LQ_INDUCTANCE		0.0012	 /* [Henry] */	
#define	M1_POLE_PAIRS		2	 /* [pairs] */	
					
/* Based value */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define	M1_U_DCB_MAX		85.8	 /* [V] */	
#define	M1_U_FOC_MAX		49.5366531	 /* [V] */	
#define	M1_I_MAX		8.008	 /* [A] */	
#define	M1_E_MAX		50	 /* [V] */	
#define	M1_N_MAX		3500	 /* [RPM] */	
#define	M1_POWER_MAX		595.034277	 /* [Watt] */	
#define	M1_OVERVOLT_LIMIT	FRAC16(	0.34965035	)	
#define	M1_UNDERVOLT_LIMIT	FRAC16(	0.20979021	)	
#define	M1_DUTY_CYCLE_LIMIT		0.96	 /* [ ] */	
					
/* Time scaling */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define 	M1_MC_PWM_CLK_FREQ		100000000	 /*  [Hz] */	
#define 	M1_CONTROL_FREQ		16000	 /*  [Hz] */	
#define 	M1_MC_SLOW_CONTROL_LOOP_FREQ		2000	 /*  [Hz] */	
#define 	M1_SPEED_LOOP_CNTR		8		
					
/* Angle, Encoder, Speed, Positon */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define	M1_ELEC_FREQ		116.6666667	 /* [ ] */	
#define	M1_ENC_LINES		1000	 /* [ ] */	
#define	M1_ENC_MODULO		3999	 /* [ ] */	
#define	M1_ENC_SCALE_FRAC		0.512		
#define	M1_ENC_SCALE	FRAC16(	0.512	)	
#define	M1_ENC_SHIFT_SCALE		5	 /* [ ] */	
#define	M1_ANGLE_SCALE	FRAC16(	0.512	)	
#define	M1_ANGLE_SHIFT_SCALE		6	 /* [ ] */	
					
/*Speed  Loop */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define	M1_RAMP_INC_SPD_CL	FRAC32(	0.0000714285714286	)	
#define	M1_SPD_CTRL_AW_KP_BASE		32		
#define	M1_SPD_CTRL_AW_BASE_TRANSFORM	FRAC16(	0.43706294	)	
#define	M1_SPD_CTRL_AW_KP	FRAC16(	0.12500000	)	
#define	M1_SPD_CTRL_AW_KI	FRAC16(	0.03000000	)	
#define	M1_SPD_CTRL_AW_KC	FRAC16(	0.50000000	)	
#define	M1_SPD_CTRL_AW_OUTPUT_LIMIT	FRAC32(	0.0117070429570430	)	
#define	M1_SPD_CALC_SCALE	FRAC16(	0.817435128	)	
#define	M1_SPD_CALC_SCALE_SHIFT		-1	 /* [ ] */	
					
/* Positon Loop */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define	M1_POS_BASE		1000		
#define	M1_COEF_Z	FRAC32(	0.001	)	
#define	M1_COEF_ENC	FRAC32(	0.0000002500000000	)	
#define	M1_POS_RAMP_UP	FRAC32(	0.0000166666666667	)	
#define	M1_POS_RAMP_DOWN	FRAC32(	0.0000166666666667	)	
#define	M1_POS_CTRL_PROP_GAIN_BASE		20000		
#define	M1_POS_CTRL_PROP_GAIN	FRAC32(	0.3000000000000000	)	
#define	M1_POS_CTRL_UPPER_LIMIT	FRAC32(	0.0000285714285714	)	
#define	M1_POS_CTRL_LOWER_LIMIT	FRAC32(	-0.0000285714285714	)	
#define	M1_POS_SMOOTHFILTER_GAIN	FRAC32(	0.0125000000000000	)	
					
/* Freemaster Variables */					
//------------------------------------------------------------------------------------------------------------------------------------------					
#define	M1_FM_I_SCALE		8008	 /* [mA] */	
#define	M1_FM_NMAX		3500	 /* [RPM] */	
#define	M1_FM_POS_SCALE		180	 /* */	
					
					
/*ACR parameter*/					
//------------------------------------------------------------------------------------------------------------------------------------------					
/*Damping Coefficient_D&Q_ACR=	0.85	*/			
/*bandWidth=	1200	[Hz]*/			
#define	M1_D_KP_GAIN_A32	ACC32(	2.397589331	)	
#define	M1_D_KP_GAIN	FRAC16(	0.599397333	)	
#define	M1_D_KP_SHIFT	(	2	)	
#define	M1_D_KI_GAIN_A32	ACC32(	0.689256541	)	
#define	M1_D_KI_GAIN	FRAC16(	0.689256541	)	
#define	M1_D_KI_SHIFT	(	0	)	
#define	M1_D_POS_LIMIT		9166		
#define	M1_D_NEG_LIMIT		-9166		
					
#define	M1_Q_KP_GAIN_A32	ACC32(	2.397589331	)	
#define	M1_Q_KP_GAIN	FRAC16(	0.599397333	)	
#define	M1_Q_KP_SHIFT	(	2	)	
#define	M1_Q_KI_GAIN_A32	ACC32(	0.689256541	)	
#define	M1_Q_KI_GAIN	FRAC16(	0.689256541	)	
#define	M1_Q_KI_SHIFT	(	0	)	
#define	M1_Q_POS_LIMIT		9166		
#define	M1_Q_NEG_LIMIT		-9166		
					
/*ACR parameter for Alignment*/					
//------------------------------------------------------------------------------------------------------------------------------------------					
/*Damping Coefficient_D&Q_ACR=	0.85	*/			
/*bandWidth=	200	[Hz]*/			
#define	M1_D_KP_GAIN_A32_ALIGN	ACC32(	0.325504937	)	
#define	M1_D_KP_GAIN_ALIGN	FRAC16(	0.651009875	)	
#define	M1_D_KP_SHIFT_ALIGN	(	-1	)	
#define	M1_D_KI_GAIN_A32_ALIGN	ACC32(	0.019146015	)	
#define	M1_D_KI_GAIN_ALIGN	FRAC16(	0.612672481	)	
#define	M1_D_KI_SHIFT_ALIGN	(	-5	)	
#define	M1_D_POS_LIMIT_ALIGN		9166		
#define	M1_D_NEG_LIMIT_ALIGN		-9166		
					
#define	M1_Q_KP_GAIN_A32_ALIGN	ACC32(	0.325504937	)	
#define	M1_Q_KP_GAIN_ALIGN	FRAC16(	0.651009875	)	
#define	M1_Q_KP_SHIFT_ALIGN	(	-1	)	
#define	M1_Q_KI_GAIN_A32_ALIGN	ACC32(	0.019146015	)	
#define	M1_Q_KI_GAIN_ALIGN	FRAC16(	0.612672481	)	
#define	M1_Q_KI_SHIFT_ALIGN	(	-5	)	
#define	M1_Q_POS_LIMIT_ALIGN		9166		
#define	M1_Q_NEG_LIMIT_ALIGN		-9166		
					
/* Filters */					
//------------------------------------------------------------------------------------------------------------------------------------------					
// Udc bus IIR, cutoff freq = 	100	[Hz]	Ts =	0.0000625	[s]
#define	M1_FILTER_UDCBUS_B1		0.019259274		
#define	M1_FILTER_UDCBUS_B2		0.019259274		
#define	M1_FILTER_UDCBUS_A2		-0.961481452		
// Speed IIR , cutoff freq = 	100	[Hz]	Ts =	0.0005	[s]
#define	M1_FILTER_SPEED_B1		0.1367287359973200		
#define	M1_FILTER_SPEED_B2		0.1367287359973200		
#define	M1_FILTER_SPEED_A2		-0.7265425280053610		
					
					
#endif /* M1_PARAMS_H_ */					
