/*******************************************************************************
*
* Copyright 2007-2015 Freescale Semiconductor, Inc.
*
* This software is owned or controlled by Freescale Semiconductor.
* Use of this software is governed by the Freescale License
* distributed with this Material.
* See the LICENSE file distributed for more details.
* 
*
****************************************************************************//*!
*
* @brief  Definition file for sine and cosine functions
* 
*******************************************************************************/
#ifndef _GFLIB_SINCOS_F32_DEFASM_H_
#define _GFLIB_SINCOS_F32_DEFASM_H_

#if defined(__cplusplus) 
extern "C" { 
#endif 
/******************************************************************************
* Includes
******************************************************************************/
#include "GFLIB_SinCos_F32_Asm.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define GFLIB_Sin_F16_Asm(f16Angle) GFLIB_Sin_F16_FAsm(f16Angle, &gsSinCoefTable_F32)
#define GFLIB_Cos_F16_Asm(f16Angle) GFLIB_Cos_F16_FAsmi(f16Angle, &gsSinCoefTable_F32)

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Global constants
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/
extern GFLIB_CONST GFLIB_SIN_T_F32 gsSinCoefTable_F32;

/******************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
* Inline functions
******************************************************************************/
#if defined(__cplusplus) 
} 
#endif 

#endif /* _GFLIB_SINCOS_F32_DEFASM_H_ */
