/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     adc.h
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    adc - ADC peripheral of S12ZVM
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of S12ZVM adc
* peripheral module.
*
******************************************************************************/

#ifndef ADC_H_
#define ADC_H_

#include "mc9s12zvml128.h"
#include "S12ZVM_devconfig.h"

/******************************************************************************
* adc MACRO definitions
******************************************************************************/
#define COMMAND_NO 			6
#define COMMAND_LENGTH		4
#define RESULT_NO			6

/******************************************************************************
* Global adc variables definition
******************************************************************************/
PR_SECTION(adcLists)
extern volatile char ADC0CommandList[COMMAND_NO][COMMAND_LENGTH];
extern volatile char ADC1CommandList[COMMAND_NO][COMMAND_LENGTH];

extern volatile unsigned short ADC0ResultList[RESULT_NO];
extern volatile unsigned short ADC1ResultList[RESULT_NO];
PR_SECTION(DEFAULT_SEC)

/******************************************************************************
* adc registers bit definition
******************************************************************************/


/******************************************************************************
* Exported functions
*******************************************************************************/
extern void adc0_init(void);
extern void adc1_init(void);
#endif /* ADC_H_ */
