/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     cpmu.c
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    cpmu - Clock, Reset and Power Management Unit of S12ZVM
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of S12ZVM cpmu
* peripheral module.
*
******************************************************************************/

#include "cpmu.h"

/******************************************************************************
* Global cpmu variables definition
******************************************************************************/


/******************************************************************************
* cpmu MACRO definitions
******************************************************************************/


/******************************************************************************
* cpmu registers bit definition
******************************************************************************/


/******************************************************************************
* Functions Definitions
*******************************************************************************/
void cpmu_init(void)
{
	// Wait for stable supply after power up
	while (GDUF_GLVLSF)
		GDUF_GLVLSF = 1;


	CPMUREFDIV_REFDIV = 3;		// 4MHz => 1MHz
	CPMUREFDIV_REFFRQ = 0;		// 0 for 1MHz - 2MHz
	CPMUSYNR_SYNDIV = 49; 		// 100 MHz VCO output
	CPMUSYNR_VCOFRQ = 3;
	CPMUPOSTDIV_POSTDIV = 1;	// 100MHz

	CPMUOSC_OSCE = 1;

	CPMUHTCTL_HTE = 1;

	// Wait for oscillator to start up (UPOSC=1) and PLL to lock (LOCK=1).
	while (CPMUIFLG_UPOSC == 0) {};
	while (CPMUIFLG_LOCK == 0) {};
	CPMURFLG  = 0x60; 	//Clear PORF and LVRF
}
