/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     gdu.c
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    gdu - GDU peripheral of S12ZVM
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of S12ZVM gdu
* peripheral module.
*
******************************************************************************/

#include "gdu.h"
/******************************************************************************
* Global gdu variables definition
******************************************************************************/


/******************************************************************************
* gdu MACRO definitions
******************************************************************************/


/******************************************************************************
* gdu registers bit definition
******************************************************************************/


/******************************************************************************
* Functions Definitions
*******************************************************************************/
void gdu_init(void)
{
	//  GDUE_EPRES = 1; // enable preserve functionality ??
	  GDUE_GCPE = 0; // charge pump

	  GDUE_GCSE0 = 1; // enable Current Sense Amplifier 0
	  GDUE_GCSE1 = 1; // enable Current Sense Amplifier 1

	  GDUF = 0xff;	// Flag Register - clear High & Low Voltage Supply flags

	  GDUCLK2_GCPCD = 4;  // Fbus / 64 !_! for bus clock 50Mhz

	  GDUCTR = 0x13;	// blanking time ! ! 0x0f
	  GDUCTR_GHHDLVL = 1; // 26 V overvoltage
	  
	  GDUDSLVL = 0x77;	// desat. level !-! previous 0x44

	  GDUDSE = 0x77;	// Clear Desaturation Error Flags
}
