/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     pmf.c
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    pmf - Pulse Width Modulator with Fault Protection of S12ZVM
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of S12ZVM pmf
* peripheral module.
*
******************************************************************************/

#include "pmf.h"

/******************************************************************************
* Global pmf variables definition
******************************************************************************/



/******************************************************************************
* pmf MACRO definitions
******************************************************************************/


/******************************************************************************
* pmf registers bit definition
******************************************************************************/


/******************************************************************************
* Functions Definitions
*******************************************************************************/
void pmf_init(void)
{
	  PMFCFG2_REV0 = 1;   			// 01 PWM generator A generates reload event.
	  PMFCFG2_REV1 = 0;

	  PMFMODA = 2500;    			// 20 kHz
	  PMFDTMA = 25;      			// 0.25 us

	  PMFVAL0 = PMFMODA >> 1;
	  PMFVAL2 = PMFMODA >> 1;
	  PMFVAL4 = PMFMODA >> 1;

	  PMFENCA_LDOKA = 1;			// apply PMF Modulo value

	  PMFENCA_PWMENA = 1;

	  PMFENCA_GLDOKA = 1;         	// 0 = Local LDOKA controls buffered registers / 1 = external Load OK controls buffered registers

	  PMFFQCA_HALFA = 1;			// Half-cycle enabled
      PMFFQCA_LDFQA = 3;            // Reload every four PWM, fcore / 1
}




