/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     ptu.c
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    ptu - Programmable trigger unit of S12ZVM
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of S12ZVM ptu
* peripheral module.
*
******************************************************************************/
#include "ptu.h"

/******************************************************************************
* Global ptu variables definition
******************************************************************************/
/****************************************************************************
 *  Trigger event list
 *
 *  +-------------------+ - (int)PTUTriggerEventList)
 *  +===================+ - Trigger 0 space
 *  +*******************+ - List 0 Offset from PTUTriggerEventList = 0 = (int)&PTUTriggerEventList[0][0][0] - (int)PTUTriggerEventList
 *  | DelayT0           |
 *  +-------------------+
 *  | DelayT1           |
 *  +-------------------+
 *  | 0x0000            | - End of delay List 0
 *  +*******************+ - List 1 Offset from PTUTriggerEventList = 3 = (int)&PTUTriggerEventList[0][1][0] - (int)PTUTriggerEventList
 *  | DelayT0           |
 *  +-------------------+
 *  | DelayT1           |
 *  +-------------------+
 *  | DelayT2           |
 *  +-------------------+
 *  | 0x0000            | - End of delay List 1
 *  +===================+ - Trigger 1 space
 *  +*******************+ - List 0 Offset from PTUTriggerEventList = 8 = (int)&PTUTriggerEventList[1][0][0] - (int)PTUTriggerEventList
 *  | DelayT0           |
 *  +-------------------+
 *  | DelayT1           |
 *  +-------------------+
 *  | 0x0000            | - End of delay List 0
 *  +*******************+ - List 1 Offset from PTUTriggerEventList = 12 = (int)&PTUTriggerEventList[1][1][0] - (int)PTUTriggerEventList
 *  | DelayT0           |
 *  +-------------------+
 *  | DelayT1           |
 *  +-------------------+
 *  | DelayT2           |
 *  +-------------------+
 *  | 0x0000            | - End of delay List 1
 *  +===================+
 *
 *
 ***************************************************************************/

PR_SECTION(ptuTrigE)
  volatile short ptuTriggerEventList[PTU_TRIGGERs_GEN_NO][PTU_LISTS_NO][PTU_COMMANDS] = {
                                              {   /*DelayT0 */
                                                  {0x0010,0x00F4,0x0000,0x0000},{0x0000,0x0000,0x0000,0x0000} // !_! for 50 MHz bus clock
                                              },
                                              {
                                            	  {0x0010,0x00F4,0x000,0x0000},{0x0000,0x0000,0x0000,0x0000} // !_! for 50 MHz bus clock
                                              }
                                            };
 PR_SECTION(DEFAULT_SEC)
/******************************************************************************
* ptu MACRO definitions
******************************************************************************/


/******************************************************************************
* ptu registers bit definition
******************************************************************************/


/******************************************************************************
* Functions Definitions
*******************************************************************************/
void ptu_init()
{
	PTUPTR = ptuTriggerEventList;
	
	TG0L1IDX = (unsigned char)(((long)&ptuTriggerEventList[0][0][0] - (long)ptuTriggerEventList) >> 1); // same as TG0L0IDX
    TG1L0IDX = (unsigned char)(((long)&ptuTriggerEventList[1][0][0] - (long)ptuTriggerEventList) >> 1);
    TG1L1IDX = (unsigned char)(((long)&ptuTriggerEventList[1][0][0] - (long)ptuTriggerEventList) >> 1); // same as TG1L0IDX

	PTUE_TG0EN = 1;       // Enable Trigger Generation 0
	PTUE_TG1EN = 1;       // Enable Trigger Generation 1
	
	//PTUDEBUG_PTUREPE = 1; // Enable Reload generation to PIN
	//PTUDEBUG_PTUT1PE=1;		// Enable Triger 2
	//PTUDEBUG_PTUT0PE=1;		// Enable Triger 1
	
	PTUC_PTULDOK = 1;     // Switch list when next reload event
}
