/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     ptu.h
*
* @author   b35258
*
* @version  0.0.1.0
*
* @date     Apr-27-2015
*
* @brief    ptu - Programmable Trigger Unit of S12ZVM
*
*******************************************************************************
*
* This file includes initial setting and MACRO definitions of S12ZVM ptu
* peripheral module.
*
******************************************************************************/

#ifndef PTU_H_
#define PTU_H_

#include "mc9s12zvml128.h"
#include "S12ZVM_devconfig.h"

/******************************************************************************
* ptu MACRO definitions
******************************************************************************/

#define PTU_TRIGGERs_GEN_NO         2
#define PTU_LISTS_NO                2
#define PTU_COMMANDS				4

/******************************************************************************
* Global ptu variables definition
******************************************************************************/
PR_SECTION(ptuTrigE)
extern volatile short ptuTriggerEventList[PTU_TRIGGERs_GEN_NO][PTU_LISTS_NO][PTU_COMMANDS];
PR_SECTION(DEFAULT_SEC)

/******************************************************************************
* ptu registers bit definition
******************************************************************************/


/******************************************************************************
* Exported functions
*******************************************************************************/
extern void ptu_init(void);

#endif /* PTU_H_ */
