/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file     actuate_s12zvm.c
*
* @author   b35258
*
* @version  1.0.1.0
*
* @date     Apr-27-2015
*
* @brief    Header file for actuator module
*
*******************************************************************************
*
*
******************************************************************************/

/******************************************************************************
| Includes
-----------------------------------------------------------------------------*/
#include "mc9s12zvml128.h"
#include "actuate_s12zvm.h"
#include "gflib.h"
#include "gmclib.h"
#include "gdflib.h"

/******************************************************************************
| External declarations
-----------------------------------------------------------------------------*/

/******************************************************************************
| Defines and macros            (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Typedefs and structures       (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Global variable definitions   (scope: module-exported)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Global variable definitions   (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function prototypes           (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function implementations      (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function implementations      (scope: module-exported)
-----------------------------------------------------------------------------*/

/**************************************************************************//*!
@brief Unmask PWM output and set 50% dytucyle 

@param[in,out]  

@return
******************************************************************************/
void EnableOutput(void)
{
	SWLIBS_3Syst_F16 f16pwm;
	
	f16pwm.f16Arg1 = FRAC16(0.5);
	f16pwm.f16Arg2 = FRAC16(0.5);
	f16pwm.f16Arg3 = FRAC16(0.5);
	
	PMFCFG2_MSK  = 0x0;
	
	SetDutycycle(&f16pwm);
}


/**************************************************************************//*!
@brief Mask PWM output and set 50% dytucyle 

@param[in,out]  

@return
******************************************************************************/
void DisableOutput(void)
{
	SWLIBS_3Syst_F16 f16pwm;
		
	f16pwm.f16Arg1 = FRAC16(0.5);
	f16pwm.f16Arg2 = FRAC16(0.5);
	f16pwm.f16Arg3 = FRAC16(0.5);
	
	PMFCFG2_MSK  = 0x3F;
	
	SetDutycycle(&f16pwm);
}

/**************************************************************************//*!
@brief Set PWM dytucyle, the dutycycle will by update on next reload event 

@param[in,out]  

@return
******************************************************************************/
void SetDutycycle(SWLIBS_3Syst_F16 *f16pwm)
{
	PMFVAL0 = MLIB_Mul(f16pwm->f16Arg1, PMFMODA, F16);	// duty cycle 0-1 -> 0-PWM_MODULO
	PMFVAL2 = MLIB_Mul(f16pwm->f16Arg2, PMFMODA, F16);
	PMFVAL4 = MLIB_Mul(f16pwm->f16Arg3, PMFMODA, F16);

	PTUC_PTULDOK = 1;
}

/**************************************************************************//*!
@brief Read GDU Flags register 

@param[in,out]  

@return
******************************************************************************/
unsigned short GetDriverError(void)
{
	return (GDUF);
}

/**************************************************************************//*!
@brief Clear GDU flag ragisters 

@param[in,out]  

@return
******************************************************************************/
tBool ClearDriverError(void)
{
	tBool retVal = (tBool)1;

	GDUF = 0xFF;

	if (GDUF != 0)
		retVal = (tBool)0;

	return(retVal);
}

/* End of file */
