/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2008 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      state_machine.c
*
* @author    b35258
* 
* @version   1.0.1.0
* 
* @date      Apr-27-2015
* 
* @brief     Header file for StateMachineFrame "c" project
*
*******************************************************************************
*
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/
#include "state_machine.h"

/******************************************************************************
| External declarations
-----------------------------------------------------------------------------*/

/******************************************************************************
| Defines and macros            (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Typedefs and structures       (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Global variable definitions   (scope: module-exported)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Global variable definitions   (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function prototypes           (scope: module-local)
-----------------------------------------------------------------------------*/


/******************************************************************************
| Function implementations      (scope: module-local)
-----------------------------------------------------------------------------*/

/******************************************************************************
| Function implementations      (scope: module-exported)
-----------------------------------------------------------------------------*/


extern PFCN_VOID_STATES state_table[12][6]={
    /* Actual state ->         'Init'           'Fault'         'Ready'         'Calib'         'Align'         'Run'*/
    /* e_fault          */ { stateFault,     stateFault,     stateFault,     stateFault,     stateFault,     stateFault},
    /* e_fault_clear    */ { stateFault,     stateInit,      stateFault,     stateFault,     stateFault,     stateFault},
    /* e_init          	*/ { stateInit,      stateFault,     stateFault,     stateFault,     stateFault,     stateFault},
    /* e_init_done      */ { stateReady,     stateFault,     stateFault,     stateFault,     stateFault,     stateFault},
    /* e_ready          */ { stateFault,     stateFault,     stateReady,     stateFault,     stateFault,     stateFault},
    /* e_app_on         */ { stateFault,     stateFault,     stateCalib,     stateFault,     stateFault,     stateFault},
    /* e_calib          */ { stateFault,     stateFault,     stateFault,     stateCalib,     stateFault,     stateFault},
    /* e_calib_done     */ { stateFault,     stateFault,     stateFault,     stateAlign,     stateFault,     stateFault},
    /* e_align          */ { stateFault,     stateFault,     stateFault,     stateFault,     stateAlign,     stateFault},
    /* e_align_done     */ { stateFault,     stateFault,     stateFault,     stateFault,     stateRun,       stateFault},
    /* e_run            */ { stateFault,     stateFault,     stateFault,     stateFault,     stateFault,     stateRun},
    /* e_app_off        */ { stateFault,     stateFault,     stateReady,     stateInit,      stateInit,      stateInit}
};



/* Actual state ->         				'Init'			'Fault'			   'Ready'         'Calib'					'Align'	         'Run'*/
extern PFCN_VOID_LED state_LED[6] = {stateLedOFF, stateLedFLASHING_FAST, stateLedOFF, stateLedFLASHING_SLOW, stateLedFLASHING_SLOW,	stateLedON};
