#!/usr/bin/env python3

"""

Copyright 2019 NXP.

This software is owned or controlled by NXP and may only be used strictly in accordance with the
license terms that accompany it. By expressly accepting such terms or by downloading, installing,
activating and/or otherwise using the software, you are agreeing that you have read, and that you
agree to comply with and are bound by, such license terms. If you do not agree to be bound by the
applicable license terms, then you may not retain, install, activate or otherwise use the software.

File
++++
/Scripts/sln_iot_utils/file_format.py

Brief
+++++
** Test script for programatically creating a thing. **

.. versionadded:: 0.0

"""
import sys
import Ivaldi.helpers as helpers

if len(sys.argv) < 3:
    print("Usage: python file_format.py inFile outFile\n")
    sys.exit(1)

def main():
    """
        Takes a file and adds necessary meta data for use with sln_flash_mgmt module on embedded device

        :returns: None
    """
    inFile = sys.argv[1]
    outFile = sys.argv[2]

    helpers.file_format(inFile, outFile)

if __name__ == '__main__':
    main()
