# SLN-VIZNAS-IOT Secure Boot Scripts

Scripts to enable secure boot and encrypted XIP on SLN-VIZNAS-IOT

## Directory Structure

```
./sln_viznas_iot_secure_boot
|── README.md
├── manf
│   ├── README.md
│   ├── prog_sec_app.py
│   ├── enable_hab.py
│   └── lock_device.py
└── oem
    ├── README.md
    ├── secure_app.py
    └── setup_hab.py
```

## Device executable binaries

The following executable binaries are loaded into flash by the Secure Boot scripts:

- sln_viznas_iot_bootstrap.srec
  - Programmed as plain text
  - Must be built with XIP boot headers set to zero
    - XIP_BOOT_HEADER_ENABLE=0
    - XIP_BOOT_HEADER_DCD_ENABLE=0
- sln_viznas_iot_bootloader.bin
  - Encrypted by scripts if -s option is NOT provided
- sln_viznas_iot_elock_oobe.bin
  - Encrypted by scripts if -s option is NOT provided
- dcd.bin
  - Device configuration data


## Key Files for Host Migration

If the Secure Boot eco-system needs to be migrated to a new host, the following files _must_ be migrated.

- /keys/_._ [All files]
- /crts/_._ [All files]
- /ca/_._ [All files]
- /Image_Binaries/ivt_flashloader_signed_nopadding.bin
- /Image_Binaries/ivt_flashloader_signed.bin
