# Offline Programming Scripts

Example scripts demonstrating how to configure PKI infrastructure and generate a secure binary

## Setup High Assurance Boot PKI Infrastructure

Typically utilized once or once for each product family.

**NOTE:** The files generated from this operation are critical. They must be backed up to prevent bricking devices.

```
(env) user@host:~/sln_imx_rt_prog_and_test $ cd Scripts/sln_viznas_iot_secure_boot/oem
(env) user@host:~/sln_imx_rt_prog_and_test/Scripts/sln_viznas_iot_secure_boot/oem $ python setup_hab.py
This operation will delete all previous keys. Continue? [y,n]
y
Cleaning keys and certificate directories...
SUCCESS: Cleaned keys and certificate directories...
Generating PKI tree...
SUCCESS: Created PKI tree.
Generating Super Root Keys (SRK)s...
SUCCESS: Generated SRKs.
Generating boot directive file to enable HAB...
SUCCESS: Generated boot directive file.
Generating secure boot(.sb) file to enable HAB...
SUCCESS: Created secure boot file to enable HAB.
Cryptographically signing flashloader image ...
SUCCESS: Created signed flashloader image.
```

## Configure Image for Encrypted Execute in Place (XIP)

Required for each Application change (bootstrap, bootloader, or main application)

```
(env) user@host:~/sln_imx_rt_prog_and_test/Scripts/sln_viznas_iot_secure_boot/oem $ python secure_app.py # -s for signing bootstrap only, no encrypted XIP
Encrypting app image ...
SUCCESS: Created encrypted image.
Creating encrypted app file ...
SUCCESS: Created encrypted app file.
```
