/*
 * Decompiled with CFR 0.152.
 */
package com.thedamfr.android.BleEventAdapter;

import android.bluetooth.BluetoothGattService;
import android.util.Log;
import com.squareup.otto.Subscribe;
import com.thedamfr.android.BleEventAdapter.BleEventBus;
import com.thedamfr.android.BleEventAdapter.events.CharacteristicChangedEvent;
import com.thedamfr.android.BleEventAdapter.events.CharacteristicReadEvent;
import com.thedamfr.android.BleEventAdapter.events.CharacteristicWriteEvent;
import com.thedamfr.android.BleEventAdapter.events.DescriptorReadEvent;
import com.thedamfr.android.BleEventAdapter.events.DescriptorWriteEvent;
import com.thedamfr.android.BleEventAdapter.events.DiscoveredDevicesEvent;
import com.thedamfr.android.BleEventAdapter.events.DiscoveryServiceEvent;
import com.thedamfr.android.BleEventAdapter.events.GattConnectionStateChangedEvent;
import com.thedamfr.android.BleEventAdapter.events.ReadRemoteRssiEvent;
import com.thedamfr.android.BleEventAdapter.events.ReliableWriteCompleted;
import com.thedamfr.android.BleEventAdapter.events.ScanningEvent;
import com.thedamfr.android.BleEventAdapter.events.ServiceDiscoveredEvent;
import java.util.List;

public class EventLogger {
    private static final String TAG = "BLE_EVENT_BUS";
    private final BleEventBus mBleEventBus = BleEventBus.getInstance();

    public EventLogger() {
        this.mBleEventBus.register(this);
    }

    @Subscribe
    public void logDeviceDiscovered(DiscoveredDevicesEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void logScanningEvent(ScanningEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(CharacteristicChangedEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(CharacteristicReadEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(CharacteristicWriteEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(DescriptorReadEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(DescriptorWriteEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(GattConnectionStateChangedEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(ReadRemoteRssiEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(ReliableWriteCompleted event) {
        Log.i((String)TAG, (String)event.toString());
    }

    @Subscribe
    public void log(ServiceDiscoveredEvent event) {
        Log.i((String)TAG, (String)event.toString());
        List services = event.getmGatt().getServices();
        for (BluetoothGattService service : services) {
            Log.i((String)TAG, (String)(service.getClass().getSimpleName() + " : " + service.getUuid().toString() + " " + service.getCharacteristics().size() + " Characteristics " + service.getIncludedServices().size() + " Included Services"));
        }
    }

    @Subscribe
    public void log(DiscoveryServiceEvent event) {
        Log.i((String)TAG, (String)event.toString());
    }
}

