/*
 * Decompiled with CFR 0.152.
 */
package com.thedamfr.android.BleEventAdapter.service.discovery.device;

import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import com.squareup.otto.Produce;
import com.thedamfr.android.BleEventAdapter.BleEventBus;
import com.thedamfr.android.BleEventAdapter.events.DiscoveredDevicesEvent;
import com.thedamfr.android.BleEventAdapter.events.ScanningEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeviceDiscoveryService
extends Service {
    private static final long SCAN_PERIOD = 5000L;
    private BleEventBus mBleEventBus;
    private Set<BluetoothDevice> mBluetoothDevices = new HashSet<BluetoothDevice>();
    private BluetoothAdapter mBluetoothAdapter;
    private Handler mHandler;
    private boolean mScanning = false;
    private ScanCallback mScanCallback;
    private BluetoothAdapter.LeScanCallback mLeScanCallback;
    private BluetoothLeScanner mLEScanner;

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.mBleEventBus = BleEventBus.getInstance();
        this.mBleEventBus.register((Object)this);
        boolean apiJBorAbove = Build.VERSION.SDK_INT >= 18;
        boolean isBleAvailable = this.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
        if (isBleAvailable && apiJBorAbove) {
            BluetoothManager bluetoothManager = (BluetoothManager)this.getSystemService("bluetooth");
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
        } else {
            this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        if (this.mBluetoothAdapter == null || !this.mBluetoothAdapter.isEnabled()) {
            this.stopSelf();
        } else {
            this.initScanCallback();
            this.scanLeDevice(true);
        }
        return 2;
    }

    private void initScanCallback() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.initCallbackLollipop();
        } else {
            this.initScanCallbackSupport();
        }
    }

    @TargetApi(value=21)
    private void initCallbackLollipop() {
        if (this.mScanCallback != null) {
            return;
        }
        this.mScanCallback = new ScanCallback(){

            public void onScanResult(int callbackType, ScanResult result) {
                super.onScanResult(callbackType, result);
                DeviceDiscoveryService.this.mBluetoothDevices.add(result.getDevice());
                DeviceDiscoveryService.this.mBleEventBus.post(new DiscoveredDevicesEvent(result.getDevice(), DeviceDiscoveryService.this.mBluetoothDevices));
            }

            public void onBatchScanResults(List<ScanResult> results) {
                super.onBatchScanResults(results);
            }

            public void onScanFailed(int errorCode) {
                super.onScanFailed(errorCode);
            }
        };
    }

    private void initScanCallbackSupport() {
        if (this.mLeScanCallback != null) {
            return;
        }
        this.mLeScanCallback = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                DeviceDiscoveryService.this.mBluetoothDevices.add(device);
                DeviceDiscoveryService.this.mBleEventBus.post(new DiscoveredDevicesEvent(device, DeviceDiscoveryService.this.mBluetoothDevices));
            }
        };
    }

    private void scanLeDevice(boolean enable) {
        if (enable) {
            this.startScanning();
        } else {
            this.stopScanning();
        }
    }

    private void startScanning() {
        this.mHandler = new Handler();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                DeviceDiscoveryService.this.stopScanning();
            }
        }, 5000L);
        this.mScanning = true;
        if (Build.VERSION.SDK_INT < 21) {
            this.mBluetoothAdapter.startLeScan(this.mLeScanCallback);
        } else {
            try {
                this.mLEScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
                ScanSettings settings = new ScanSettings.Builder().setScanMode(2).build();
                this.mLEScanner.startScan(null, settings, this.mScanCallback);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mBleEventBus.post(new ScanningEvent(this.mScanning));
    }

    private void stopScanning() {
        this.mScanning = false;
        if (Build.VERSION.SDK_INT < 21) {
            this.mBluetoothAdapter.stopLeScan(this.mLeScanCallback);
        } else {
            try {
                this.mLEScanner.stopScan(this.mScanCallback);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mBleEventBus.post(new ScanningEvent(false));
        this.stopSelf();
    }

    @Produce
    public DiscoveredDevicesEvent produceAnswer() {
        return new DiscoveredDevicesEvent(null, this.mBluetoothDevices);
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopScanning();
        this.mBleEventBus.unregister((Object)this);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

