/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.authorization.AuthCancellation;
import com.amazon.identity.auth.device.api.authorization.AuthorizeListener;
import com.amazon.identity.auth.device.api.authorization.AuthorizeResult;
import com.amazon.identity.auth.device.api.authorization.Scope;
import com.amazon.identity.auth.device.api.workflow.RequestContext;
import com.amazon.identity.auth.device.interactive.InteractiveRequest;
import com.amazon.identity.auth.device.utils.LWAConstants;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthorizeRequest
extends InteractiveRequest<AuthorizeListener, AuthorizeResult, AuthCancellation, AuthError> {
    static final String REQUEST_TYPE = "com.amazon.identity.auth.device.authorization.request.authorize";
    static final String EXTRA_REQUESTED_SCOPES = "requestedScopes";
    static final String EXTRA_SHOULD_RETURN_USER_DATA = "shouldReturnUserData";
    private List<Scope> scopes = new LinkedList<Scope>();
    private GrantType grantType = GrantType.ACCESS_TOKEN;
    private String codeChallenge;
    private String codeChallengeMethod;
    private boolean shouldShowProgress = true;
    private boolean shouldReturnUserData = true;

    AuthorizeRequest(RequestContext requestContext) {
        super(requestContext);
    }

    @Override
    public final String getRequestType() {
        return REQUEST_TYPE;
    }

    @Override
    public final Class<AuthorizeListener> getListenerClass() {
        return AuthorizeListener.class;
    }

    @Override
    public final Bundle getRequestExtras() {
        Bundle extras = new Bundle();
        String[] stringScopes = new String[this.scopes.size()];
        for (int index = 0; index < this.scopes.size(); ++index) {
            stringScopes[index] = this.scopes.get(index).getName();
        }
        extras.putStringArray(EXTRA_REQUESTED_SCOPES, stringScopes);
        extras.putBoolean(EXTRA_SHOULD_RETURN_USER_DATA, this.shouldReturnUserData());
        extras.putBoolean(LWAConstants.AUTHORIZE_BUNDLE_KEY.SHOW_PROGRESS.val, this.shouldShowProgress);
        return extras;
    }

    public void addScope(Scope scope) {
        this.scopes.add(scope);
    }

    public void addScopes(Scope ... scopesToAdd) {
        Collections.addAll(this.scopes, scopesToAdd);
    }

    public void setProofKeyParameters(String codeChallenge, String codeChallengeMethod) {
        this.setCodeChallenge(codeChallenge);
        this.setCodeChallengeMethod(codeChallengeMethod);
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    public void setGrantType(GrantType grantType) {
        this.grantType = grantType;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public boolean shouldReturnUserData() {
        return this.shouldReturnUserData;
    }

    public void setShouldReturnUserData(boolean shouldReturnUserData) {
        this.shouldReturnUserData = shouldReturnUserData;
    }

    public boolean shouldShowProgress() {
        return this.shouldShowProgress;
    }

    public void showProgress(boolean showProgress) {
        this.shouldShowProgress = showProgress;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder
    extends InteractiveRequest.Builder<AuthorizeRequest> {
        private final AuthorizeRequest request;

        public Builder(RequestContext context) {
            super(context);
            this.request = new AuthorizeRequest(this.requestContext);
        }

        public Builder addScope(Scope scope) {
            this.request.addScope(scope);
            return this;
        }

        public Builder addScopes(Scope ... scopes) {
            this.request.addScopes(scopes);
            return this;
        }

        public Builder forGrantType(GrantType grantType) {
            this.request.setGrantType(grantType);
            return this;
        }

        public Builder shouldReturnUserData(boolean shouldReturnUserData) {
            this.request.setShouldReturnUserData(shouldReturnUserData);
            return this;
        }

        public Builder withProofKeyParameters(String codeChallenge, String codeChallengeMethod) {
            this.request.setProofKeyParameters(codeChallenge, codeChallengeMethod);
            return this;
        }

        public Builder showProgress(boolean showProgress) {
            this.request.showProgress(showProgress);
            return this;
        }

        @Override
        public AuthorizeRequest build() {
            return this.request;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GrantType {
        ACCESS_TOKEN,
        AUTHORIZATION_CODE;

    }
}

