/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.CodePairError;
import com.amazon.identity.auth.device.api.authorization.CodePairListener;
import com.amazon.identity.auth.device.api.authorization.CodePairResult;
import com.amazon.identity.auth.device.api.authorization.CreateCodePairRequest;
import com.amazon.identity.auth.device.api.authorization.GetTokenListener;
import com.amazon.identity.auth.device.api.authorization.GetTokenRequest;
import com.amazon.identity.auth.device.api.authorization.GetTokenResult;
import com.amazon.identity.auth.device.api.authorization.PollingTask;
import com.amazon.identity.auth.device.api.authorization.Scope;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.CodePair;
import com.amazon.identity.auth.device.datastore.CodePairDataSource;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.ScopeUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodePairManager {
    private static final String LOG_TAG = CodePairManager.class.getName();
    private static ServerCommunication mServerCommunication = new ServerCommunication();
    private static Comparator<Scope> ScopeNameComparator = new Comparator<Scope>(){

        @Override
        public int compare(Scope scope1, Scope scope2) {
            String scopeName1 = scope1.getName();
            String scopeName2 = scope2.getName();
            return scopeName1.compareTo(scopeName2);
        }
    };

    public static void setServerCommunication(ServerCommunication serverCommunication) {
        mServerCommunication = serverCommunication;
    }

    public static void createCodePair(CreateCodePairRequest request) {
        final Context context = request.getContext();
        final List<Scope> scopeList = request.getScopes();
        final CodePairListener listener = request.getListener();
        final AppInfo appInfo = request.getAppInfo();
        if (scopeList == null || scopeList.isEmpty()) {
            MAPLog.e(LOG_TAG, "Vend code pair - No scopes passed in");
            CodePairError error = new CodePairError("No scopes provided in parameters", CodePairError.ERROR_TYPE.ERROR_BAD_API_PARAM);
            listener.onError(error);
            return;
        }
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                if (!CodePairManager.deleteExistingCodePairSuccessful(listener, scopeList, context)) {
                    return;
                }
                CodePair newCodePair = null;
                try {
                    newCodePair = CodePairManager.getNewCodePairFromPandaService(scopeList, context, appInfo, listener);
                }
                catch (Exception e) {
                    MAPLog.e(LOG_TAG, "Failed to get the code pair from Panda Service", e);
                    CodePairError error = new CodePairError("Failed to get the code pair from Panda Service", CodePairError.ERROR_TYPE.ERROR_INVALID_REQUEST);
                    listener.onError(error);
                    return;
                }
                if (!CodePairManager.insertCodePairIntoDatabaseSuccessful(listener, newCodePair, context)) {
                    return;
                }
                MAPLog.i(LOG_TAG, "New Code Pair has been inserted into the database");
                CodePairResult result = CodePairManager.getCodePairResult(newCodePair);
                listener.onSuccess(result);
            }
        });
    }

    private static boolean deleteExistingCodePairSuccessful(CodePairListener listener, List<Scope> scopeList, Context context) {
        String[] scopeValues = CodePairManager.convertScopeListToStringArray(scopeList);
        CodePair existingCodePair = CodePairManager.getExistingCodePair(scopeValues, context);
        if (existingCodePair != null) {
            MAPLog.i(LOG_TAG, "The existing code pair found! Delete it before getting a new one");
            if (existingCodePair.delete(context)) {
                MAPLog.i(LOG_TAG, "Succesfully deleted the old code pair and will create a new one!");
            } else {
                MAPLog.e(LOG_TAG, "Unable to delete code pair in db");
                CodePairError error = new CodePairError("Unable to delete code pair in db", CodePairError.ERROR_TYPE.ERROR_DATA_STORAGE);
                listener.onError(error);
                return false;
            }
        }
        return true;
    }

    private static boolean insertCodePairIntoDatabaseSuccessful(CodePairListener listener, CodePair codePair, Context context) {
        if (codePair.insert(context) == -1L) {
            CodePairError error = new CodePairError("Unable to insert code pair into db", CodePairError.ERROR_TYPE.ERROR_DATA_STORAGE);
            listener.onError(error);
            return false;
        }
        return true;
    }

    private static CodePairResult getCodePairResult(CodePair codePair) {
        CodePairResult result = new CodePairResult(codePair.getUserCode(), codePair.getVerificationUri().toString());
        MAPLog.i(LOG_TAG, "user code is: " + codePair.getUserCode());
        return result;
    }

    public static void getToken(GetTokenRequest request) {
        final Context context = request.getContext();
        final List<Scope> scopeList = request.getScopes();
        final AppInfo appInfo = request.getAppInfo();
        final GetTokenListener listener = request.getListener();
        if (scopeList == null || scopeList.isEmpty()) {
            MAPLog.e(LOG_TAG, "Get Authorization tokens - No scopes passed in");
            AuthError error = new AuthError("No scopes provided in parameters", AuthError.ERROR_TYPE.ERROR_BAD_API_PARAM);
            listener.onError(error);
            return;
        }
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                String[] scopeValues = CodePairManager.convertScopeListToStringArray(scopeList);
                String scopeString = ScopeUtils.convertScopeArrayToString(scopeValues);
                String accessTokenValue = null;
                try {
                    accessTokenValue = CodePairManager.vendAccessToken(scopeString, context, appInfo);
                }
                catch (AuthError e) {
                    listener.onError(e);
                    return;
                }
                if (accessTokenValue != null) {
                    MAPLog.i(LOG_TAG, "Vend Access Token for the given scope successfully, simply return it");
                    listener.onSuccess(new GetTokenResult(accessTokenValue));
                    return;
                }
                CodePair codePair = CodePairManager.getExistingCodePair(scopeValues, context);
                if (!CodePairManager.isCodePairValid(listener, codePair)) {
                    return;
                }
                ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
                long intervalInMillSec = codePair.getInterval() * 1000;
                scheduledExecutorService.scheduleWithFixedDelay(new PollingTask(mServerCommunication, listener, codePair, scheduledExecutorService, context, appInfo, scopeString), 0L, intervalInMillSec, TimeUnit.MILLISECONDS);
            }
        });
    }

    private static boolean isCodePairValid(GetTokenListener listener, CodePair codePair) {
        if (codePair == null) {
            MAPLog.e(LOG_TAG, "No existing code pair found for getting token");
            AuthError error = new AuthError("No existing code pair found for getting token", AuthError.ERROR_TYPE.ERROR_BAD_API_PARAM);
            listener.onError(error);
            return false;
        }
        if (CodePairManager.hasCodePairExpired(codePair.getExpirationTime())) {
            MAPLog.e(LOG_TAG, "Code Pair has already expired");
            AuthError error = new AuthError("Code Pair has already expired", AuthError.ERROR_TYPE.ERROR_BAD_API_PARAM);
            listener.onError(error);
            return false;
        }
        return true;
    }

    private static String vendAccessToken(String scopeString, Context context, AppInfo appInfo) throws AuthError {
        TokenVendor tokenVendor = new TokenVendor();
        String accessTokenValue = null;
        Bundle options = new Bundle();
        try {
            accessTokenValue = tokenVendor.vendToken(null, new String[]{scopeString}, context, options, appInfo);
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, e.getMessage(), e);
            throw new AuthError("Error communicating with server", e, AuthError.ERROR_TYPE.ERROR_IO);
        }
        return accessTokenValue;
    }

    private static CodePair getExistingCodePair(String[] scopeValues, Context context) {
        MAPLog.i(LOG_TAG, "Try finding an exisiting code pair for requested scopes");
        CodePairDataSource codePairDataSource = CodePairDataSource.getInstance(context);
        String scopesString = ScopeUtils.convertScopeArrayToString(scopeValues);
        CodePair existingCodePair = (CodePair)codePairDataSource.findOneRow(new String[]{"Scopes"}, new String[]{scopesString});
        if (existingCodePair == null) {
            MAPLog.i(LOG_TAG, "Existing code pair not found!");
            return null;
        }
        MAPLog.i(LOG_TAG, "Existing code pair found for given scope");
        return existingCodePair;
    }

    private static CodePair getNewCodePairFromPandaService(List<Scope> scopeList, Context context, AppInfo appInfo, CodePairListener listener) throws CodePairError, IOException, AuthError {
        if (scopeList == null || scopeList.isEmpty()) {
            return null;
        }
        com.amazon.identity.auth.device.dataobject.Scope[] scopes = CodePairManager.convertToInternalScope(scopeList);
        CodePair codePair = mServerCommunication.getCodePair(scopes, context, appInfo);
        return codePair;
    }

    private static com.amazon.identity.auth.device.dataobject.Scope[] convertToInternalScope(List<Scope> scopeList) {
        com.amazon.identity.auth.device.dataobject.Scope[] internalScopes = new com.amazon.identity.auth.device.dataobject.Scope[scopeList.size()];
        int count = 0;
        for (Scope scope : scopeList) {
            String scopeName = scope.getName();
            JSONObject scopeData = scope.getScopeData();
            if (scopeData != null) {
                String scopeDataString = scopeData.toString();
                internalScopes[count++] = new com.amazon.identity.auth.device.dataobject.Scope(scopeName, scopeDataString);
                continue;
            }
            internalScopes[count++] = new com.amazon.identity.auth.device.dataobject.Scope(scopeName);
        }
        return internalScopes;
    }

    public static boolean hasCodePairExpired(Date expirationTime) {
        return expirationTime.before(new Date());
    }

    private static String[] convertScopeListToStringArray(List<Scope> scopeList) {
        Collections.sort(scopeList, ScopeNameComparator);
        String[] scopeValues = new String[scopeList.size()];
        int count = 0;
        for (Scope scope : scopeList) {
            scopeValues[count++] = scope.getName();
        }
        return scopeValues;
    }
}

