/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.content.Context;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.authorization.GetTokenListener;
import com.amazon.identity.auth.device.api.authorization.Scope;
import com.amazon.identity.auth.device.api.workflow.RequestContext;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GetTokenRequest {
    private RequestContext mRequestContext;
    private List<Scope> mScopes;
    private GetTokenListener mListener;

    private GetTokenRequest(RequestContext requestContext) throws AuthError {
        if (requestContext == null) {
            throw new IllegalArgumentException("requestContext must be non-null");
        }
        this.mRequestContext = requestContext;
        this.mScopes = new ArrayList<Scope>();
    }

    public Context getContext() {
        return this.mRequestContext.getContext();
    }

    public List<Scope> getScopes() {
        return this.mScopes;
    }

    public AppInfo getAppInfo() {
        ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
        AppInfo appInfo = appIdentifier.getAppInfo(this.getContext().getPackageName(), this.getContext());
        return appInfo;
    }

    public void addScope(Scope scope) {
        this.mScopes.add(scope);
    }

    public void addScopes(Scope ... scopesToAdd) {
        Collections.addAll(this.mScopes, scopesToAdd);
    }

    public void addListener(GetTokenListener listener) {
        this.mListener = listener;
    }

    public GetTokenListener getListener() {
        return this.mListener;
    }

    public static final class Builder {
        private final GetTokenRequest mRequest;

        public Builder(RequestContext requestContext) throws AuthError {
            if (requestContext == null) {
                throw new IllegalArgumentException("A RequestContext is necessary for making interactive requests");
            }
            this.mRequest = new GetTokenRequest(requestContext);
        }

        public Builder addScope(Scope scope) {
            this.mRequest.addScope(scope);
            return this;
        }

        public Builder addScopes(Scope ... scopes) {
            this.mRequest.addScopes(scopes);
            return this;
        }

        public Builder addListener(GetTokenListener listener) {
            this.mRequest.addListener(listener);
            return this;
        }

        public GetTokenRequest build() throws AuthError {
            if (this.mRequest.getListener() == null) {
                throw new AuthError("get token listener has not been registered", AuthError.ERROR_TYPE.ERROR_INVALID_API);
            }
            if (this.mRequest.getScopes() == null || this.mRequest.getScopes().isEmpty()) {
                throw new AuthError("No scopes provided for the get token request", AuthError.ERROR_TYPE.ERROR_INVALID_API);
            }
            return this.mRequest;
        }
    }
}

