/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.workflow;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.net.Uri;
import android.support.v4.app.FragmentActivity;
import com.amazon.identity.auth.device.RequestManager;
import com.amazon.identity.auth.device.api.workflow.ListenerNotFoundException;
import com.amazon.identity.auth.device.endpoint.ResponseUri;
import com.amazon.identity.auth.device.interactive.AggregateInteractiveListener;
import com.amazon.identity.auth.device.interactive.InteractiveAPI;
import com.amazon.identity.auth.device.interactive.InteractiveListener;
import com.amazon.identity.auth.device.interactive.InteractiveRequest;
import com.amazon.identity.auth.device.interactive.InteractiveRequestMap;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.interactive.InteractiveState;
import com.amazon.identity.auth.device.interactive.InternalInteractiveListener;
import com.amazon.identity.auth.device.interactive.RequestSource;
import com.amazon.identity.auth.device.interactive.RequestSourceActivityWrapper;
import com.amazon.identity.auth.device.interactive.RequestSourceContextWrapper;
import com.amazon.identity.auth.device.interactive.RequestSourceFragmentActivityWrapper;
import com.amazon.identity.auth.device.interactive.RequestSourceFragmentWrapper;
import com.amazon.identity.auth.device.interactive.RequestSourceSupportFragmentWrapper;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestContext {
    private static final String LOG_TAG = RequestContext.class.getName();
    private final UUID requestContextId;
    private final RequestSource requestSource;
    private final Map<String, Set<InteractiveListener<?, ?, ?>>> listeners;

    public static RequestContext create(Context context) {
        if (context instanceof FragmentActivity) {
            return RequestContext.create((FragmentActivity)context);
        }
        if (context instanceof Activity) {
            return RequestContext.create((Activity)context);
        }
        return RequestContext.create(new RequestSourceContextWrapper(context));
    }

    @Deprecated
    public static RequestContext create(Activity activity) {
        return RequestContext.create(new RequestSourceActivityWrapper(activity));
    }

    @SuppressLint(value={"NewApi"})
    public static RequestContext create(Fragment fragment) {
        return RequestContext.create(new RequestSourceFragmentWrapper(fragment));
    }

    @Deprecated
    public static RequestContext create(FragmentActivity activity) {
        return RequestContext.create(new RequestSourceFragmentActivityWrapper(activity));
    }

    public static RequestContext create(android.support.v4.app.Fragment fragment) {
        return RequestContext.create(new RequestSourceSupportFragmentWrapper(fragment));
    }

    private static RequestContext create(RequestSource requestSource) {
        Object source = requestSource.getBackingObject();
        RequestContext context = InteractiveRequestMap.getInstance().getRequestContextForSource(source);
        if (context == null) {
            context = new RequestContext(requestSource);
            InteractiveRequestMap.getInstance().putRequestContextForSource(source, context);
            MAPLog.pii(LOG_TAG, "Created RequestContext " + context.requestContextId, "requestSource=" + requestSource.getBackingObject());
        } else {
            MAPLog.pii(LOG_TAG, "Reusing RequestContext " + context.requestContextId, "requestSource=" + requestSource.getBackingObject());
        }
        return context;
    }

    RequestContext(RequestSource requestSource) {
        if (requestSource == null) {
            throw new IllegalArgumentException("requestSource must be non-null");
        }
        this.requestSource = requestSource;
        this.requestContextId = UUID.randomUUID();
        this.listeners = new HashMap();
    }

    String getId() {
        return this.requestContextId.toString();
    }

    public Context getContext() {
        return this.requestSource.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(InteractiveListener<?, ?, ?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        String requestType = listener.getRequestType();
        MAPLog.pii(LOG_TAG, "RequestContext " + this.requestContextId + ": registerListener for of request type " + requestType, "listener=" + listener);
        Map<String, Set<InteractiveListener<?, ?, ?>>> map = this.listeners;
        synchronized (map) {
            Set<InteractiveListener<?, ?, ?>> listenersForType = this.listeners.get(requestType);
            if (listenersForType == null) {
                listenersForType = new HashSet();
                this.listeners.put(requestType, listenersForType);
            }
            listenersForType.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterListener(InteractiveListener<?, ?, ?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        String requestType = listener.getRequestType();
        MAPLog.pii(LOG_TAG, "RequestContext " + this.requestContextId + ": unregisterListener for listener of request type " + requestType, "listener=" + listener);
        Map<String, Set<InteractiveListener<?, ?, ?>>> map = this.listeners;
        synchronized (map) {
            Set<InteractiveListener<?, ?, ?>> listenersOfType = this.listeners.get(requestType);
            if (listenersOfType == null) {
                return false;
            }
            return listenersOfType.remove(listener);
        }
    }

    public void onResume() {
        MAPLog.d(LOG_TAG, "RequestContext " + this.requestContextId + ": onResume");
        InteractiveState interactiveState = this.requestSource.getInteractiveState();
        if (interactiveState != null) {
            interactiveState.processPendingResponses(this);
        } else {
            MAPLog.e(LOG_TAG, "RequestContext " + this.requestContextId + ": could not retrieve interactive state to process pending responses");
        }
    }

    public void onStartRequest(InteractiveRequestRecord request) {
        if (request == null) {
            throw new IllegalArgumentException("request must be non-null");
        }
        MAPLog.d(LOG_TAG, "RequestContext " + this.requestContextId + ": onStartRequest for request ID " + request.getRequestId());
        this.requestSource.onStartRequest(request);
    }

    public void processResponse(final InteractiveRequestRecord request, final Uri uri) {
        if (request == null) {
            throw new IllegalArgumentException("request must be non-null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("uri must be non-null");
        }
        MAPLog.pii(LOG_TAG, "RequestContext " + this.requestContextId + ": processing response", "uri=" + uri.toString());
        final Context context = this.requestSource.getContext();
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                try {
                    if (!RequestManager.getInstance().handleResponse(uri, context, RequestContext.this)) {
                        Map<String, String> state = new ResponseUri(uri).getStateValues();
                        String requestType = state.get("InteractiveRequestType");
                        Set listenersOfType = RequestContext.this.getListenersInternal(requestType, InternalInteractiveListener.class);
                        for (InternalInteractiveListener listener : listenersOfType) {
                            listener.onRequestCompletion(context, request, uri);
                        }
                    }
                }
                catch (Exception e) {
                    MAPLog.e(LOG_TAG, "RequestContext " + RequestContext.this.requestContextId + ": Unable to handle activity result", e);
                }
            }
        });
    }

    public void assertListenerPresent(InteractiveAPI api) throws ListenerNotFoundException {
        if (api == null) {
            throw new IllegalArgumentException("api must be non-null");
        }
        this.getListenersInternal(api.getRequestType(), null);
    }

    public <T extends InteractiveListener<S, U, V>, S, U, V> InteractiveListener<S, U, V> getAggregateListener(InteractiveRequest<T, S, U, V> request) throws ListenerNotFoundException {
        Set<T> listeners = this.getListeners(request, request.getListenerClass());
        return new AggregateInteractiveListener(request.getRequestType(), listeners);
    }

    public <T> Set<T> getListeners(InteractiveAPI api, Class<T> listenerClass) {
        if (api == null) {
            throw new IllegalArgumentException("api must be non-null");
        }
        if (listenerClass == null) {
            throw new IllegalArgumentException("listenerClass must be non-null");
        }
        return this.getListenersInternal(api.getRequestType(), listenerClass);
    }

    public boolean isHookNeededOnUIResume() {
        return this.requestSource.isHookNeededOnUIResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Set<T> getListenersInternal(String requestType, Class<T> listenerClass) throws ListenerNotFoundException {
        Set<InteractiveListener<?, ?, ?>> listenersOfType;
        if (requestType == null) {
            throw new IllegalArgumentException("requestType must be non-null");
        }
        Map<String, Set<InteractiveListener<?, ?, ?>>> map = this.listeners;
        synchronized (map) {
            listenersOfType = this.listeners.get(requestType);
        }
        if (listenersOfType == null || listenersOfType.isEmpty()) {
            throw new ListenerNotFoundException("No listeners were registered with type \"" + requestType + "\" for RequestContext " + this.requestContextId + ". Listener types present: " + this.listeners.keySet());
        }
        if (listenerClass == null) {
            return null;
        }
        HashSet<T> typedListeners = new HashSet<T>(listenersOfType.size());
        for (InteractiveListener<?, ?, ?> listener : listenersOfType) {
            try {
                typedListeners.add(listenerClass.cast(listener));
            }
            catch (ClassCastException e) {
                throw new ListenerNotFoundException("Failed to retrieve listener of class type \"" + listenerClass.toString() + "\" for request type \"" + requestType + "\"", e);
            }
        }
        return typedListeners;
    }
}

