/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.StoredPreferences;
import com.amazon.identity.auth.device.api.authorization.AuthorizationManager;
import com.amazon.identity.auth.device.api.authorization.AuthorizeRequest;
import com.amazon.identity.auth.device.api.authorization.Region;
import com.amazon.identity.auth.device.appid.ThirdPartyAppIdentifier;
import com.amazon.identity.auth.device.authorization.EndpointDomainBuilder;
import com.amazon.identity.auth.device.authorization.ProfileHelper;
import com.amazon.identity.auth.device.authorization.Stage;
import com.amazon.identity.auth.device.authorization.ThirdPartyAuthorizationHelper;
import com.amazon.identity.auth.device.authorization.TokenHelper;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.thread.AuthzCallbackFuture;
import com.amazon.identity.auth.device.thread.ThreadUtils;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.Arrays;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalAuthManager {
    private static final String LOG_TAG = InternalAuthManager.class.getName();
    private static final ThirdPartyAppIdentifier appIdentifier = new ThirdPartyAppIdentifier();
    private static final TokenVendor tokenVendor = new TokenVendor();
    private String clientId;
    private static InternalAuthManager sharedInstance;
    private AppInfo appInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InternalAuthManager getInstance(Context context) {
        if (sharedInstance != null) return sharedInstance;
        Class<InternalAuthManager> clazz = InternalAuthManager.class;
        synchronized (InternalAuthManager.class) {
            if (sharedInstance != null) return sharedInstance;
            sharedInstance = new InternalAuthManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public InternalAuthManager(Context context) {
        this.appInfo = appIdentifier.getAppInfo(context.getPackageName(), context);
        if (this.appInfo == null || this.appInfo.getClientId() == null) {
            throw new IllegalArgumentException("Invalid API Key");
        }
        this.clientId = this.appInfo.getClientId();
        this.updateAppState(context);
    }

    public Future<Bundle> authorize(final AuthorizeRequest request, final Context context, final String[] scopes, final Bundle options, final AuthorizationListener listener) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("scopes must not be null or empty!");
        }
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling authorize: scopes=" + Arrays.toString(scopes));
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                Bundle allOptions;
                if (!InternalAuthManager.this.isAPIKeyValid(context)) {
                    listener.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                Bundle bundle = allOptions = options == null ? new Bundle() : new Bundle(options);
                if (!allOptions.containsKey(AuthzConstants.BUNDLE_KEY.SANDBOX.val)) {
                    allOptions.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, AuthorizationManager.isSandboxMode(context));
                }
                ThirdPartyAuthorizationHelper authzHelper = new ThirdPartyAuthorizationHelper();
                try {
                    authzHelper.authorize(request, context, context.getPackageName(), InternalAuthManager.this.clientId, InternalAuthManager.this.getRedirectURI(context), scopes, true, tokenVendor, listener, allOptions);
                }
                catch (AuthError e) {
                    listener.onError(e);
                }
            }
        });
        return null;
    }

    public Future<Bundle> getToken(final Context context, final String[] scopes, APIListener listener) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException("scopes must not be null or empty!");
        }
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling getToken: scopes=" + Arrays.toString(scopes));
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                try {
                    if (!InternalAuthManager.this.isAPIKeyValid(context)) {
                        callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                        return;
                    }
                    Bundle options = new Bundle();
                    options.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, AuthorizationManager.isSandboxMode(context));
                    TokenHelper.getToken(context, context.getPackageName(), InternalAuthManager.this.clientId, scopes, new APIListener(){

                        public void onSuccess(Bundle response) {
                            callbackFuture.onSuccess(response);
                        }

                        public void onError(AuthError e) {
                            callbackFuture.onError(e);
                        }
                    }, new ThirdPartyAppIdentifier(), options);
                }
                catch (AuthError e) {
                    callbackFuture.onError(e);
                }
            }
        });
        return callbackFuture;
    }

    public Future<Bundle> getProfile(final Context context, final Bundle options, APIListener listener) {
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling getProfile");
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                Bundle allOptions;
                if (!InternalAuthManager.this.isAPIKeyValid(context)) {
                    callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                Bundle bundle = allOptions = options == null ? new Bundle() : new Bundle(options);
                if (!allOptions.containsKey(AuthzConstants.BUNDLE_KEY.SANDBOX.val)) {
                    allOptions.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, AuthorizationManager.isSandboxMode(context));
                }
                ProfileHelper.getProfile(context, context.getPackageName(), allOptions, new APIListener(){

                    public void onSuccess(Bundle response) {
                        callbackFuture.onSuccess(response);
                    }

                    public void onError(AuthError e) {
                        callbackFuture.onError(e);
                    }
                });
            }
        });
        return callbackFuture;
    }

    public Future<Bundle> clearAuthorizationState(final Context context, APIListener listener) {
        final AuthzCallbackFuture callbackFuture = new AuthzCallbackFuture(listener);
        MAPLog.i(LOG_TAG, context.getPackageName() + " calling clearAuthorizationState");
        ThreadUtils.THREAD_POOL.execute(new Runnable(){

            public void run() {
                if (!InternalAuthManager.this.isAPIKeyValid(context)) {
                    callbackFuture.onError(new AuthError("APIKey is invalid", AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
                    return;
                }
                AuthError serverSideError = InternalAuthManager.this.clearServerSideAuthorizationState(context);
                AuthError ssoSideError = InternalAuthManager.this.clearSSOSideAuthorizationState(context);
                DatabaseHelper.clearAuthorizationState(context);
                if (serverSideError == null && ssoSideError == null) {
                    callbackFuture.onSuccess(new Bundle());
                } else if (serverSideError != null) {
                    callbackFuture.onError(serverSideError);
                } else if (ssoSideError != null) {
                    callbackFuture.onError(ssoSideError);
                }
            }
        });
        return callbackFuture;
    }

    private AuthError clearSSOSideAuthorizationState(Context context) {
        try {
            DatabaseHelper.clearServiceAuthorizationState(context);
        }
        catch (AuthError e) {
            return e;
        }
        return null;
    }

    public boolean isAPIKeyValid(Context context) {
        return appIdentifier.isAPIKeyValid(context) ? this.clientId != null : false;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectURI(Context context) {
        return appIdentifier.getRedirectUrl(context);
    }

    public void setRegion(Context context, Region region) {
        if (DefaultLibraryInfo.getLibraryRegion() != region) {
            StoredPreferences.setRegion(context, region);
            DefaultLibraryInfo.setLibraryRegion(region);
        }
    }

    public Region getRegion(Context context) {
        Region region = StoredPreferences.getRegion(context);
        if (Region.AUTO == region) {
            return new EndpointDomainBuilder(context, this.appInfo).getRegionForAPIKey();
        }
        return region;
    }

    private void updateAppState(Context context) {
        String hostType = MAPUtils.getHostType(context, context.getPackageName());
        if ("development".equalsIgnoreCase(hostType)) {
            DefaultLibraryInfo.setOverrideAppStage(Stage.DEVO);
        } else if ("gamma".equalsIgnoreCase(hostType)) {
            DefaultLibraryInfo.setOverrideAppStage(Stage.PRE_PROD);
        }
    }

    private AuthError clearServerSideAuthorizationState(Context context) {
        try {
            Bundle options = new Bundle();
            options.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, AuthorizationManager.isSandboxMode(context));
            TokenHelper.clearAuthStateServerSide(context, this.appInfo, options);
        }
        catch (AuthError e) {
            return e;
        }
        return null;
    }
}

