/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.authorization;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.appid.AppIdentifier;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.endpoint.TokenVendor;
import com.amazon.identity.auth.device.service.MAPServiceResult;
import com.amazon.identity.auth.device.shared.APIListener;
import com.amazon.identity.auth.device.utils.LWAServiceWrapper;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;

public final class TokenHelper {
    private static final String LOG_TAG = TokenHelper.class.getName();
    private static TokenVendor mTokenVendor = new TokenVendor();

    private TokenHelper() {
    }

    static void setServerCommunicaton(ServerCommunication serverCommunication) {
        mTokenVendor.setServerCommunication(serverCommunication);
    }

    public static void getToken(Context context, String packageName, String clientId, String[] scopes, APIListener listener, AppIdentifier appIdentifier, Bundle options) throws AuthError {
        MAPLog.i(LOG_TAG, "GetToken pkg=" + packageName + " scopes=" + Arrays.toString(scopes));
        AppInfo appInfo = appIdentifier.getAppInfo(packageName, context);
        if (appInfo == null) {
            MAPLog.e(LOG_TAG, "appInfo is null for " + packageName);
            listener.onError(new AuthError("APIKey info is unavailable for " + packageName, null, AuthError.ERROR_TYPE.ERROR_ACCESS_DENIED));
            return;
        }
        try {
            String authzToken = TokenHelper.getTokenInternal(context, packageName, scopes, appInfo, options);
            Bundle result = authzToken == null ? new Bundle() : MAPServiceResult.getOnSuccessBundle(AuthzConstants.BUNDLE_KEY.TOKEN.val, authzToken);
            listener.onSuccess(result);
        }
        catch (AuthError e) {
            listener.onError(e);
        }
    }

    public static String getTokenInternal(Context context, String packageName, String[] scopes, AppInfo appInfo, Bundle options) throws AuthError {
        try {
            String authzToken = mTokenVendor.vendToken(null, scopes, context, options, appInfo);
            if (authzToken == null) {
                authzToken = TokenHelper.getTokenFromSSO(context, packageName, scopes);
            }
            MAPLog.pii(LOG_TAG, "GetToken", " appid=" + appInfo.getAppFamilyId() + " atzToken=" + authzToken);
            return authzToken;
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, e.getMessage(), e);
            throw new AuthError("Error communicating with server", e, AuthError.ERROR_TYPE.ERROR_IO);
        }
    }

    public static void clearAuthStateServerSide(Context context, AppInfo appInfo, Bundle options) throws AuthError {
        try {
            mTokenVendor.clearAuthStateServerSide(context, appInfo, options);
        }
        catch (IOException e) {
            MAPLog.e(LOG_TAG, e.getMessage(), e);
            throw new AuthError(e.getMessage(), AuthError.ERROR_TYPE.ERROR_IO);
        }
    }

    private static String getTokenFromSSO(Context context, final String packageName, final String[] scopes) throws AuthError {
        return (String)new LWAServiceWrapper<String>(){

            @Override
            protected String doWork(Context context, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
                return TokenHelper.getTokenFromService(context, scopes, packageName, service);
            }
        }.execute(context, new ThirdPartyServiceHelper());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getTokenFromService(Context context, String[] scopes, String packageName, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
        DatabaseHelper.clearAuthorizationState(context);
        ProfileDataSource.getInstance(context).deleteAllRows();
        Bundle result = service.getToken(null, packageName, scopes);
        if (result == null) return null;
        result.setClassLoader(context.getClassLoader());
        String tokenFromService = result.getString("accessAtzToken");
        if (!TextUtils.isEmpty((CharSequence)tokenFromService)) {
            return tokenFromService;
        }
        AuthError authError = (AuthError)result.getParcelable("AUTH_ERROR_EXECEPTION");
        if (authError == null) {
            MAPLog.i(LOG_TAG, "No results from service");
            return null;
        }
        if (AuthError.ERROR_TYPE.ERROR_INVALID_TOKEN == authError.getType()) {
            MAPLog.e(LOG_TAG, "Invalid token. Cleaning up.");
            ProfileDataSource.getInstance(context).deleteAllRows();
            return null;
        }
        MAPLog.i(LOG_TAG, "AuthError from service " + authError.getMessage());
        ThirdPartyServiceHelper.clearCachedService(context);
        throw authError;
    }
}

