/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.dataobject;

import java.util.Locale;

public class Scope {
    private final String mScopeName;
    private final String mScopeData;
    private String scopeDescription = null;

    public Scope(String scopeName) {
        this(scopeName, null);
    }

    public Scope(String scopeName, String scopeData) {
        this.mScopeName = scopeName;
        this.mScopeData = scopeData;
    }

    public String getScopeName() {
        return this.mScopeName;
    }

    public String getScopeData() {
        return this.mScopeData;
    }

    public boolean isLocal() {
        return Scope.isLocal(this.mScopeName);
    }

    public synchronized String getScopeDescription() {
        if (this.scopeDescription == null) {
            this.scopeDescription = Scope.getDescription(this.mScopeName, Locale.getDefault().getLanguage());
        }
        return this.scopeDescription;
    }

    public void setScopeDescription(String scopeDescription) {
        this.scopeDescription = scopeDescription;
    }

    public static String getDescription(String scopeName, String locale) {
        return scopeName;
    }

    public static boolean isLocal(String scopeName) {
        assert (scopeName != null);
        return scopeName.startsWith("device");
    }
}

