/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.datastore.AbstractDataSource;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppInfoDataSource
extends AbstractDataSource<AppInfo> {
    private static final String LOG_TAG = AppInfoDataSource.class.getName();
    private static final String[] ALL_COLUMNS = AppInfo.ALL_COLUMNS;
    private static AppInfoDataSource INSTANCE;

    private AppInfoDataSource(SQLiteDatabase database) {
        super(database);
    }

    public static synchronized AppInfoDataSource getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new AppInfoDataSource(MAPUtils.getMAPdatabase(context));
        }
        return INSTANCE;
    }

    public static void resetInstance() {
        INSTANCE = null;
        MAPUtils.resetDatabaseInstance();
    }

    public List<AppInfo> findByAppFamilyId(String appFamilyId) {
        return this.findAllRowsBySingleColumn(ALL_COLUMNS[AppInfo.COL_INDEX.APP_FAMILY_ID.colId], appFamilyId);
    }

    public AppInfo findByAppVariantId(String appVariantId) {
        return (AppInfo)this.findOneRowBySingleColumn(ALL_COLUMNS[AppInfo.COL_INDEX.APP_VARIANT_ID.colId], appVariantId);
    }

    public AppInfo findByPackageName(String packageName) {
        return (AppInfo)this.findOneRowBySingleColumn(ALL_COLUMNS[AppInfo.COL_INDEX.PACKAGE_NAME.colId], packageName);
    }

    public AppInfo findByPrimaryKey(String appVariantId) {
        return this.findByAppVariantId(appVariantId);
    }

    public int deleteByAppFamilyId(String appFamilyId) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[AppInfo.COL_INDEX.APP_FAMILY_ID.colId], appFamilyId);
    }

    public int deleteByPackageName(String packageName) {
        return this.deleteRowsBySingleColumn(ALL_COLUMNS[AppInfo.COL_INDEX.PACKAGE_NAME.colId], packageName);
    }

    @Override
    public String getLogTag() {
        return LOG_TAG;
    }

    @Override
    public AppInfo cursorToObject(Cursor cursor) {
        if (cursor == null || cursor.getCount() == 0) {
            return null;
        }
        try {
            AppInfo to_return = new AppInfo();
            to_return.setRowId(cursor.getLong(this.getColumnIndex(cursor, AppInfo.COL_INDEX.ROW_ID.colId)));
            to_return.setAppFamilyId(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.APP_FAMILY_ID.colId)));
            to_return.setAppVariantId(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.APP_VARIANT_ID.colId)));
            to_return.setPackageName(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.PACKAGE_NAME.colId)));
            to_return.setAllowedScopes(MAPUtils.toStringArray(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.ALLOWED_SCOPES.colId)), ","));
            to_return.setGrantedPermissions(MAPUtils.toStringArray(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.GRANTED_PERMISSIONS.colId)), ","));
            to_return.setClientId(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.CLIENT_ID.colId)));
            to_return.setAuthorizationHost(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.AUTHZ_HOST.colId)));
            to_return.setExchangeHost(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.EXCHANGE_HOST.colId)));
            to_return.setPayload(cursor.getString(this.getColumnIndex(cursor, AppInfo.COL_INDEX.PAYLOAD.colId)));
            return to_return;
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "" + e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String getTableName() {
        return "AppInfo";
    }

    @Override
    public String[] getAllColumns() {
        return ALL_COLUMNS;
    }
}

