/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.datastore;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.datastore.AppInfoDataSource;
import com.amazon.identity.auth.device.datastore.AuthorizationTokenDataSource;
import com.amazon.identity.auth.device.datastore.CodePairDataSource;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.datastore.RequestedScopeDataSource;
import com.amazon.identity.auth.device.utils.LWAServiceWrapper;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public final class DatabaseHelper
extends SQLiteOpenHelper {
    private static final String LOG_TAG = DatabaseHelper.class.getName();
    private static final String DATE_FORMAT_UTC = "yyyy-MM-dd HH:mm:ss'Z'";
    private static final String DATE_FORMAT_LOCAL = "yyyy-MM-dd HH:mm:ss";
    private static final long SECOND_MILLIS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
    private static final int THIRD_PARTY_VER_2_X = 4;
    private static final int THIRD_PARTY_VER_2_1_X = 5;
    private static final int THIRD_PARTY_VER_2_2_X = 6;
    private static final int THIRD_PARTY_VER_2_3_X = 7;
    private static final int THIRD_PARTY_VER_2_3_1 = 8;
    private static final int THIRD_PARTY_VER_2_4 = 9;
    public static final int MAP_DB_VERSION = 9;
    public static final String MAP_DB_NAME = "MAPDataStore.db";
    public static final String appInfoTable = "AppInfo";
    public static final String appInfo_AppFamilyId = "AppFamilyId";
    public static final String appInfo_AppVariantId = "AppVariantId";
    public static final String appInfo_PackageName = "PackageName";
    public static final String appInfo_AllowedScopes = "AllowedScopes";
    public static final String appInfo_GrantedPermissions = "GrantedPermissions";
    public static final String appInfo_ClientId = "ClientId";
    public static final String appInfo_AuthzHost = "AuthzHost";
    public static final String appInfo_ExchangeHost = "ExchangeHost";
    public static final String appInfo_Payload = "Payload";
    public static final String requestedScopeTable = "RequestedScope";
    public static final String requestedScope_Scope = "Scope";
    public static final String requestedScope_AppFamilyId = "AppId";
    public static final String requestedScope_DirectedId = "DirectedId";
    public static final String requestedScope_AuthorizationAccessTokenId = "AtzAccessTokenId";
    public static final String requestedScope_AuthorizationRefreshTokenId = "AtzRefreshTokenId";
    public static final String authorizationTokenTable = "AuthorizationToken";
    public static final String authorizationToken_Id = "Id";
    public static final String authorizationToken_AppFamilyId = "AppId";
    public static final String authorizationToken_Token = "Token";
    public static final String authorizationToken_CreationTime = "CreationTime";
    public static final String authorizationToken_ExpirationTime = "ExpirationTime";
    public static final String authorizationToken_Type = "type";
    public static final String authorizationToken_MiscData = "MiscData";
    public static final String authorizationToken_DirectedId = "directedId";
    public static final String authorizationCodeTable = "AuthorizationCode";
    public static final String authorizationCode_Id = "Id";
    public static final String authorizationCode = "Code";
    public static final String authorizationCode_AppId = "AppId";
    public static final String authorizationCode_AuthorizationTokenId = "AuthorizationTokenId";
    public static final String profileTable = "Profile";
    public static final String profile_Id = "Id";
    public static final String profile_ExpirationTime = "ExpirationTime";
    public static final String profile_AppId = "AppId";
    public static final String profile_Data = "Data";
    public static final String codePairTable = "CodePair";
    public static final String codePair_Id = "Id";
    public static final String codePair_UserCode = "UserCode";
    public static final String codePair_DeviceCode = "DeviceCode";
    public static final String codePair_VerificationUri = "VerificationUri";
    public static final String codePair_Interval = "Interval";
    public static final String codePair_CreationTime = "CreationTime";
    public static final String codePair_ExpirationTime = "ExpirationTime";
    public static final String codePair_AppId = "AppId";
    public static final String codePair_Scopes = "Scopes";

    public DatabaseHelper(Context context) {
        super(context, MAP_DB_NAME, null, 9);
        MAPLog.pii(LOG_TAG, "DatabaseHelper created ver=9", "MAP_DB_NAME=MAPDataStore.db");
    }

    public void onCreate(SQLiteDatabase db) {
        MAPLog.i(LOG_TAG, "onCreate called");
        db.execSQL("CREATE TABLE IF NOT EXISTS AppInfo (AppFamilyId TEXT NOT NULL, PackageName TEXT NOT NULL, AllowedScopes TEXT, GrantedPermissions TEXT, ClientId TEXT, AppVariantId TEXT,AuthzHost TEXT, ExchangeHost TEXT, Payload TEXT,UNIQUE (PackageName), PRIMARY KEY (AppVariantId))");
        db.execSQL("CREATE INDEX IF NOT EXISTS app_info_index_pkg_name ON AppInfo (PackageName)");
        db.execSQL("CREATE INDEX IF NOT EXISTS app_info_index_app_variant_id ON AppInfo (AppVariantId)");
        db.execSQL("CREATE TABLE IF NOT EXISTS RequestedScope (Scope TEXT NOT NULL, AppId TEXT NOT NULL, DirectedId TEXT, AtzAccessTokenId INTEGER NOT NULL, AtzRefreshTokenId INTEGER NOT NULL, PRIMARY KEY (Scope,AppId,AtzAccessTokenId,AtzRefreshTokenId))");
        db.execSQL("CREATE INDEX IF NOT EXISTS requested_scope_index_scope ON RequestedScope (Scope)");
        db.execSQL("CREATE INDEX IF NOT EXISTS requested_scope_index_app_id ON RequestedScope (AppId)");
        db.execSQL("CREATE INDEX IF NOT EXISTS requested_scope_index_atz_access_token_id ON RequestedScope (AtzAccessTokenId)");
        db.execSQL("CREATE INDEX IF NOT EXISTS requested_scope_index_directed_id ON RequestedScope (DirectedId)");
        db.execSQL("CREATE INDEX IF NOT EXISTS requested_scope_index_atz_refresh_token_id ON RequestedScope (AtzRefreshTokenId)");
        db.execSQL("CREATE TRIGGER IF NOT EXISTS requested_scope_valid_atz_access_token_id BEFORE INSERT ON RequestedScope FOR EACH ROW BEGIN SELECT CASE WHEN (new.AtzAccessTokenId != " + RequestedScope.OUTCOME.UNKNOWN.longVal + " AND new." + requestedScope_AuthorizationAccessTokenId + " != " + RequestedScope.OUTCOME.REJECTED.longVal + " AND new." + requestedScope_AuthorizationAccessTokenId + " < " + RequestedScope.OUTCOME.GRANTED_LOCALLY.longVal + ") THEN RAISE(ABORT, 'Invalid authorization token ID') END; END;");
        db.execSQL("CREATE TRIGGER IF NOT EXISTS requested_scope_valid_atz_refresh_token_id BEFORE INSERT ON RequestedScope FOR EACH ROW BEGIN SELECT CASE WHEN (new.AtzRefreshTokenId != " + RequestedScope.OUTCOME.UNKNOWN.longVal + " AND new." + requestedScope_AuthorizationRefreshTokenId + " != " + RequestedScope.OUTCOME.REJECTED.longVal + " AND new." + requestedScope_AuthorizationRefreshTokenId + " < " + RequestedScope.OUTCOME.GRANTED_LOCALLY.longVal + ") THEN RAISE(ABORT, 'Invalid authorization token ID') END; END;");
        MAPLog.d(LOG_TAG, "Attempting to create authorizationTokenTable TABLE");
        db.execSQL("CREATE TABLE IF NOT EXISTS AuthorizationToken (Id INTEGER PRIMARY KEY AUTOINCREMENT, AppId TEXT NOT NULL, Token TEXT NOT NULL, CreationTime DATETIME NOT NULL, ExpirationTime DATETIME NOT NULL, MiscData BLOB, type INTEGER NOT NULL, directedId TEXT )");
        db.execSQL("CREATE INDEX IF NOT EXISTS authz_token_index_app_id ON AuthorizationToken (AppId)");
        db.execSQL("CREATE INDEX IF NOT EXISTS authz_token_index_directed_id ON AuthorizationToken (directedId)");
        db.execSQL("CREATE TABLE IF NOT EXISTS AuthorizationCode (Id INTEGER PRIMARY KEY AUTOINCREMENT, Code TEXT NOT NULL, AppId TEXT NOT NULL, AuthorizationTokenId INTEGER NOT NULL )");
        db.execSQL("CREATE INDEX IF NOT EXISTS authz_code_index_app_id ON AuthorizationCode (AppId)");
        db.execSQL("CREATE INDEX IF NOT EXISTS authz_code_index_token_id ON AuthorizationCode (AuthorizationTokenId)");
        db.execSQL("CREATE TABLE IF NOT EXISTS Profile (Id INTEGER PRIMARY KEY AUTOINCREMENT, ExpirationTime DATETIME NOT NULL, AppId TEXT NOT NULL, Data TEXT NOT NULL )");
        db.execSQL("CREATE INDEX IF NOT EXISTS profile_index_app_id ON Profile (AppId)");
        String createCodePairTableString = "CREATE TABLE IF NOT EXISTS CodePair (Id INTEGER PRIMARY KEY AUTOINCREMENT, UserCode TEXT NOT NULL, DeviceCode TEXT NOT NULL, VerificationUri TEXT NOT NULL, Interval INTEGER NOT NULL, CreationTime DATETIME NOT NULL, ExpirationTime DATETIME NOT NULL, AppId TEXT NOT NULL, Scopes TEXT NOT NULL )";
        SQLiteStatement statement = db.compileStatement(createCodePairTableString);
        statement.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesColumnExist(SQLiteDatabase db, String tableName, String columnName) {
        MAPLog.i(LOG_TAG, "Checking if COL=" + columnName + " in table=" + tableName + " exists");
        if (TextUtils.isEmpty((CharSequence)columnName) || TextUtils.isEmpty((CharSequence)tableName) || db == null || !db.isOpen()) {
            MAPLog.i(LOG_TAG, "Column does NOT exist");
            return false;
        }
        Cursor cursor = null;
        try {
            String query = "select * from sqlite_master where name = '" + tableName + "' and sql like '%" + columnName + "%' ";
            cursor = db.rawQuery(query, null);
            if (cursor == null) {
                MAPLog.i(LOG_TAG, "Column does NOT exist");
                boolean bl = false;
                return bl;
            }
            if (cursor.moveToFirst()) {
                MAPLog.i(LOG_TAG, "Column does exist");
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLiteException e) {
            MAPLog.i(LOG_TAG, "SQLiteException: " + e.getMessage());
            MAPLog.i(LOG_TAG, "Column does NOT exist");
            boolean bl = false;
            return bl;
        }
        finally {
            cursor.close();
        }
        MAPLog.i(LOG_TAG, "Column does NOT exist");
        return false;
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        MAPLog.i(LOG_TAG, "onUpgrade called old=" + oldVersion + " new=" + newVersion);
        if (oldVersion < 4 && newVersion >= 4) {
            MAPLog.i(LOG_TAG, "Doing upgrades for 4");
            db.execSQL("DROP TABLE IF EXISTS AuthorizationToken");
            db.execSQL("DROP TABLE IF EXISTS RequestedScope");
            db.execSQL("DROP TABLE IF EXISTS AppInfo");
            db.execSQL("DROP INDEX IF EXISTS RequestedScope.requested_scope_index_directed_id");
            db.execSQL("DROP INDEX IF EXISTS RequestedScope.requested_scope_index_atz_token_id");
            db.execSQL("DROP TRIGGER IF EXISTS requested_scope_valid_atz_token_id");
        }
        if (oldVersion < 5 && newVersion >= 5) {
            MAPLog.i(LOG_TAG, "Doing upgrades for 5");
        }
        if (oldVersion < 6 && newVersion >= 6) {
            MAPLog.i(LOG_TAG, "Doing upgrades for 6");
            db.execSQL("DROP TABLE IF EXISTS AppInfo");
        }
        if (oldVersion < 8 && newVersion >= 8 || oldVersion < 9 && newVersion >= 9) {
            MAPLog.i(LOG_TAG, "Doing upgrades for 8");
            db.execSQL("DROP TABLE IF EXISTS AppInfo");
        }
        if (newVersion > 9) {
            throw new IllegalStateException("Database version was updated, but no upgrade was done ver=8");
        }
        this.onCreate(db);
    }

    public static Date truncateFractionalSeconds(Date date) {
        if (date != null) {
            date.setTime(date.getTime() / SECOND_MILLIS * SECOND_MILLIS);
            return date;
        }
        return null;
    }

    public static void clearAuthorizationState(Context context) {
        MAPLog.i(LOG_TAG, "Clearing Authorization Locally");
        AppInfoDataSource.getInstance(context).deleteAllRows();
        AuthorizationTokenDataSource.getInstance(context).deleteAllRows();
        RequestedScopeDataSource.getInstance(context).deleteAllRows();
        ProfileDataSource.getInstance(context).deleteAllRows();
        CodePairDataSource.getInstance(context).deleteAllRows();
    }

    public static void clearServiceAuthorizationState(Context context) throws AuthError {
        DatabaseHelper.clearServiceAuthorizationState(context, new ThirdPartyServiceHelper());
    }

    public static void clearServiceAuthorizationState(Context context, ThirdPartyServiceHelper helper) throws AuthError {
        new LWAServiceWrapper<Bundle>(){

            @Override
            protected Bundle doWork(Context workContext, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
                DatabaseHelper.clearServiceAuthorizationStateWorker(workContext, service);
                return new Bundle();
            }
        }.execute(context, helper);
    }

    public static SimpleDateFormat getDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_UTC, Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public static SimpleDateFormat getDateFormatLocal() {
        return new SimpleDateFormat(DATE_FORMAT_LOCAL, Locale.US);
    }

    public static Date parseDate(String dateString) throws ParseException {
        if (dateString.endsWith("Z")) {
            return DatabaseHelper.getDateFormat().parse(dateString);
        }
        return DatabaseHelper.getDateFormatLocal().parse(dateString);
    }

    private static void clearServiceAuthorizationStateWorker(Context context, AmazonAuthorizationServiceInterface service) throws AuthError, RemoteException {
        MAPLog.i(LOG_TAG, "Clearing Authorization via Service");
        Bundle result = service.clearAuthorizationState(null, context.getPackageName());
        if (result != null && result.containsKey("AUTH_ERROR_EXECEPTION")) {
            throw AuthError.extractError(result);
        }
    }
}

