/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.annotation.SuppressLint;
import android.net.SSLCertificateSocketFactory;
import android.text.TextUtils;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.endpoint.Response;
import com.amazon.identity.auth.device.utils.DefaultLibraryInfo;
import com.amazon.identity.auth.device.utils.NetworkUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTTPSRequest<T extends Response> {
    public static final int HTTPS_TIMEOUT_MILLISECONDS = 30000;
    public static final int NUM_RETRY_ATTEMPTS = 3;
    protected static final String UTF8 = "UTF-8";
    private static final String LOG_TAG = AbstractHTTPSRequest.class.getName();
    private static final HostnameVerifier TRUST_ALL_HOSTNAME_VERIFIER = AbstractHTTPSRequest.getAllTrustingHostNameVerifier();
    private static final SSLSocketFactory TRUST_ALL_HOSTS_SOCKET_FACTORY = AbstractHTTPSRequest.getAllTrustingSSLSocketFactory();
    protected final List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();

    List<Pair<String, String>> getHeaders() {
        return this.headers;
    }

    public final T submit() throws AuthError {
        HttpsURLConnection httpsURLConnection = null;
        try {
            this.initializeHeaders();
            this.initializePostParams();
            String url = this.getRequestUrl();
            httpsURLConnection = this.initializeHttp(url);
            this.logRequestInfo(httpsURLConnection);
            this.writeBody(httpsURLConnection);
            MAPLog.i(LOG_TAG, "Request url: " + httpsURLConnection.getURL());
            return this.retryAndGetResponse(httpsURLConnection);
        }
        catch (MalformedURLException mue) {
            MAPLog.e(LOG_TAG, "Invalid URL", mue);
            throw new AuthError("MalformedURLException", mue, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
        catch (IOException ioe) {
            MAPLog.e(LOG_TAG, "Received IO error when executing token request:" + ioe.toString(), ioe);
            throw new AuthError("Received communication error when executing token request", ioe, AuthError.ERROR_TYPE.ERROR_IO);
        }
        catch (IllegalStateException ise) {
            MAPLog.e(LOG_TAG, "Received IllegalStateException error when executing token request:" + ise.toString(), ise);
            throw new AuthError("Received communication error when executing token request", ise, AuthError.ERROR_TYPE.ERROR_COM);
        }
    }

    protected void writeBody(HttpsURLConnection httpsURLConnection) throws IOException, AuthError {
    }

    protected void initializePostParams() throws AuthError {
    }

    protected T retryAndGetResponse(HttpsURLConnection httpsURLConnection) throws AuthError, IOException {
        HttpsURLConnection retryHttpsURLConnection = httpsURLConnection;
        HttpResponse httpResponse = null;
        for (int attempt = 0; attempt < 3; ++attempt) {
            httpResponse = HttpResponse.readResponse(retryHttpsURLConnection);
            MAPLog.pii(LOG_TAG, "Get response.", "Response code: " + httpResponse.getResponseCode());
            if (!NetworkUtils.hasReceived500(httpResponse.getResponseCode())) break;
            retryHttpsURLConnection = this.initializeHttp(this.getRequestUrl());
            this.writeBody(retryHttpsURLConnection);
            MAPLog.w(LOG_TAG, "Received " + httpResponse.getResponseCode() + " error on request attempt " + (attempt + 1) + " of " + 3);
        }
        return this.generateResponse(httpResponse);
    }

    private void logRequestInfo(HttpsURLConnection httpsURLConnection) {
        MAPLog.pii(LOG_TAG, "Http request method", httpsURLConnection.getRequestMethod());
        Map<String, List<String>> headers = httpsURLConnection.getRequestProperties();
        if (headers != null) {
            MAPLog.i(LOG_TAG, "Number of Headers : " + headers.size());
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                String headerName = header.getKey();
                List<String> headerValueList = header.getValue();
                if (headerValueList == null || headerValueList.size() <= 0) continue;
                MAPLog.pii(LOG_TAG, "Header used for request: name=" + headerName, "val=" + TextUtils.join((CharSequence)", ", headerValueList));
            }
        } else {
            MAPLog.i(LOG_TAG, "No Headers");
        }
        this.logRequest();
    }

    private static HostnameVerifier getAllTrustingHostNameVerifier() {
        return new AllowAllHostnameVerifier();
    }

    @SuppressLint(value={"SSLCertificateSocketFactoryGetInsecure"})
    private static SSLSocketFactory getAllTrustingSSLSocketFactory() {
        return SSLCertificateSocketFactory.getInsecure((int)0, null);
    }

    protected HttpsURLConnection initializeHttp(String urlStr) throws MalformedURLException, IOException, AuthError {
        URL url = new URL(urlStr);
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)url.openConnection();
        if (DefaultLibraryInfo.isDevo()) {
            MAPLog.d(LOG_TAG, "Trusting all ssl connetions.");
            httpsURLConnection.setSSLSocketFactory(TRUST_ALL_HOSTS_SOCKET_FACTORY);
            httpsURLConnection.setHostnameVerifier(TRUST_ALL_HOSTNAME_VERIFIER);
        }
        this.setHttpMethod(httpsURLConnection);
        httpsURLConnection.setConnectTimeout(30000);
        this.writeHeaders(httpsURLConnection);
        return httpsURLConnection;
    }

    protected void writeHeaders(HttpsURLConnection httpsURLConnection) {
        for (Pair<String, String> header : this.headers) {
            httpsURLConnection.setRequestProperty((String)header.first, (String)header.second);
        }
    }

    protected abstract String getRequestUrl() throws MalformedURLException;

    protected abstract void initializeHeaders();

    protected abstract void logRequest();

    protected abstract T generateResponse(HttpResponse var1);

    protected abstract void setHttpMethod(HttpsURLConnection var1) throws ProtocolException;
}

