/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractPandaRequest;
import com.amazon.identity.auth.device.endpoint.Response;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJsonPandaRequest<T extends Response>
extends AbstractPandaRequest<T> {
    private static final String APPLICATION_JSON_CONTENT_TYPE = "application/json";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";

    public AbstractJsonPandaRequest(Context context, AppInfo appInfo) {
        super(context, appInfo);
    }

    @Override
    protected List<Pair<String, String>> getExtraHeaders() {
        ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        headers.add(new Pair((Object)CONTENT_TYPE_HEADER, (Object)APPLICATION_JSON_CONTENT_TYPE));
        return headers;
    }

    @Override
    protected String prepareRequestBody() throws AuthError {
        JSONObject json = new JSONObject();
        try {
            for (Pair param : this.postParameters) {
                json.put((String)param.first, param.second);
            }
            return json.toString();
        }
        catch (JSONException e) {
            throw new AuthError("Received JSONException while building request", e, AuthError.ERROR_TYPE.ERROR_BAD_PARAM);
        }
    }
}

