/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.EndpointDomainBuilder;
import com.amazon.identity.auth.device.authorization.Service;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractHTTPSRequest;
import com.amazon.identity.auth.device.endpoint.Response;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"TrustAllX509TrustManager"})
public abstract class AbstractPandaRequest<T extends Response>
extends AbstractHTTPSRequest<T> {
    protected static final String DI_HW_NAME = "di.hw.name";
    protected static final String DI_HW_VERSION = "di.hw.version";
    protected static final String DI_OS_NAME = "di.os.name";
    protected static final String DI_OS_VERSION = "di.os.version";
    protected static final String DI_SDK_VERSION = "di.sdk.version";
    protected static final String APP_VERSION = "app_version";
    protected static final String APP_NAME = "app_name";
    protected static final String ANDROID_OS_NAME = "Android";
    private static final int MAX_NUM_POST_PARAMS = 10;
    protected final List<Pair<String, String>> postParameters;
    private static final String LOG_TAG = AbstractPandaRequest.class.getName();
    private static final String DEFAULT_USER_AGENT = "LWAAndroidSDK/3.0.4/Android/" + Build.VERSION.RELEASE + "/" + Build.MODEL;
    private static final String HTTP_USER_AGENT = "User-Agent";
    private static final String AMZN_REQUEST_ID_HEADER = "X-Amzn-RequestId";
    private String appName;
    private String appVersion;
    private String libVersion;
    private Context context;
    private AppInfo appInfo;

    public AbstractPandaRequest(Context context, AppInfo appInfo) {
        this.context = context;
        this.appInfo = appInfo;
        this.appName = MAPUtils.getAppName(context);
        this.appVersion = MAPUtils.getVersion(context);
        this.libVersion = "3.0.4";
        this.postParameters = new ArrayList<Pair<String, String>>(10);
    }

    protected abstract String getEndPoint();

    protected abstract List<Pair<String, String>> getExtraHeaders();

    protected abstract List<Pair<String, String>> getExtraParameters() throws AuthError;

    protected boolean isSandboxEnabled() {
        return false;
    }

    @Override
    protected String getRequestUrl() throws MalformedURLException {
        String endPoint = this.getEndPoint();
        String domain = new EndpointDomainBuilder(this.context, this.appInfo).forService(Service.PANDA).forSandbox(this.isSandboxEnabled()).getDomain();
        return new URL(domain + endPoint).toString();
    }

    @Override
    protected void initializePostParams() throws AuthError {
        this.addExtraParameters();
        this.addAppInfoParameters();
        this.addDeviceParams();
    }

    private void addDeviceParams() {
        if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER) && !Build.MANUFACTURER.equals("unknown")) {
            this.postParameters.add((Pair<String, String>)new Pair((Object)DI_HW_NAME, (Object)Build.MANUFACTURER));
        }
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL) && !Build.MODEL.equals("unknown")) {
            this.postParameters.add((Pair<String, String>)new Pair((Object)DI_HW_VERSION, (Object)Build.MODEL));
        }
        this.postParameters.add((Pair<String, String>)new Pair((Object)DI_OS_NAME, (Object)ANDROID_OS_NAME));
        if (!TextUtils.isEmpty((CharSequence)Build.VERSION.RELEASE) && !Build.VERSION.RELEASE.equals("unknown")) {
            this.postParameters.add((Pair<String, String>)new Pair((Object)DI_OS_VERSION, (Object)Build.VERSION.RELEASE));
        }
        this.postParameters.add((Pair<String, String>)new Pair((Object)DI_SDK_VERSION, (Object)this.libVersion));
    }

    private void addAppInfoParameters() {
        this.postParameters.add((Pair<String, String>)new Pair((Object)APP_NAME, (Object)this.appName));
        if (this.appVersion != null) {
            this.postParameters.add((Pair<String, String>)new Pair((Object)APP_VERSION, (Object)this.appVersion));
        }
    }

    private void addExtraParameters() throws AuthError {
        List<Pair<String, String>> extraParameters = this.getExtraParameters();
        if (extraParameters != null) {
            this.postParameters.addAll(extraParameters);
        }
    }

    @Override
    protected void setHttpMethod(HttpsURLConnection httpsURLConnection) throws ProtocolException {
        httpsURLConnection.setRequestMethod("POST");
    }

    @Override
    protected void initializeHeaders() {
        this.addDefaultHeaders();
        this.addExtraHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeBody(HttpsURLConnection httpsURLConnection) throws IOException, AuthError {
        httpsURLConnection.setDoOutput(true);
        String requestBody = this.prepareRequestBody();
        if (TextUtils.isEmpty((CharSequence)requestBody)) {
            return;
        }
        byte[] bodyBytes = requestBody.getBytes("UTF-8");
        httpsURLConnection.setFixedLengthStreamingMode(bodyBytes.length);
        OutputStream outStream = httpsURLConnection.getOutputStream();
        try {
            outStream.write(bodyBytes);
        }
        finally {
            try {
                outStream.flush();
            }
            catch (IOException e) {
                MAPLog.e(LOG_TAG, "Couldn't flush write body stream", e);
            }
            try {
                outStream.close();
            }
            catch (IOException e) {
                MAPLog.e(LOG_TAG, "Couldn't close write body stream", e);
            }
        }
    }

    protected String prepareRequestBody() throws AuthError, UnsupportedEncodingException {
        StringBuilder body = new StringBuilder();
        boolean first = true;
        for (Pair<String, String> param : this.getPostParameters()) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)param.first)) || TextUtils.isEmpty((CharSequence)((CharSequence)param.second))) continue;
            if (first) {
                first = false;
            } else {
                body.append("&");
            }
            body.append(URLEncoder.encode((String)param.first, "UTF-8"));
            body.append("=");
            body.append(URLEncoder.encode((String)param.second, "UTF-8"));
        }
        String bodyString = body.toString();
        MAPLog.pii(LOG_TAG, "Request body", bodyString);
        return bodyString;
    }

    private void addDefaultHeaders() {
        this.headers.add(new Pair((Object)HTTP_USER_AGENT, (Object)DEFAULT_USER_AGENT));
        this.headers.add(new Pair((Object)"Accept-Language", (Object)this.getDeviceLanguage()));
        this.headers.add(new Pair((Object)"Accept", (Object)"application/json"));
        this.headers.add(new Pair((Object)"Accept-Charset", (Object)"UTF-8"));
        this.headers.add(new Pair((Object)AMZN_REQUEST_ID_HEADER, (Object)UUID.randomUUID().toString()));
    }

    private String getDeviceLanguage() {
        String deviceLanguage = Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
        MAPLog.i(LOG_TAG, "Device Language is: " + deviceLanguage);
        return deviceLanguage;
    }

    private void addExtraHeaders() {
        List<Pair<String, String>> extraHeaders = this.getExtraHeaders();
        if (extraHeaders != null) {
            this.headers.addAll(extraHeaders);
        }
    }

    private List<Pair<String, String>> getPostParameters() {
        for (Pair<String, String> parameter : this.postParameters) {
            if (parameter != null) {
                MAPLog.pii(LOG_TAG, "Parameter Added to request", "name=" + (String)parameter.first + " val=" + (String)parameter.second);
                continue;
            }
            MAPLog.e(LOG_TAG, "Parameter Added to request was NULL");
        }
        return this.postParameters;
    }
}

