/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.Scope;
import com.amazon.identity.auth.device.endpoint.AbstractJsonPandaRequest;
import com.amazon.identity.auth.device.endpoint.CreateCodePairResponse;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.utils.ScopeUtils;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CreateCodePairRequest
extends AbstractJsonPandaRequest<CreateCodePairResponse> {
    private static final String LOG_TAG = CreateCodePairRequest.class.getName();
    private static final String CREATE_CODE_PAIR_ENDPOINT = "/auth/O2/create/codepair";
    private static final String DEVICE_CODE_GRANT = "device_code";
    private static final String SCOPE = "scope";
    private static final String SCOPE_DATA = "scope_data";
    private static final String RESPONSE_TYPE_PARAM = "response_type";
    private static final String APP_CLIENT_ID_PARAM = "client_id";
    private final Scope[] mScopes;
    private final String mClientId;
    private final String mAppId;

    public CreateCodePairRequest(Context context, AppInfo appInfo, Scope[] scopes) {
        super(context, appInfo);
        this.mScopes = scopes;
        this.mClientId = appInfo.getClientId();
        this.mAppId = appInfo.getAppFamilyId();
    }

    @Override
    protected String getEndPoint() {
        return CREATE_CODE_PAIR_ENDPOINT;
    }

    @Override
    protected List<Pair<String, String>> getExtraParameters() throws AuthError {
        ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
        parameters.add(new Pair((Object)RESPONSE_TYPE_PARAM, (Object)DEVICE_CODE_GRANT));
        for (Scope scope : this.mScopes) {
            parameters.add((Pair<String, String>)new Pair((Object)SCOPE, (Object)scope.getScopeName()));
            if (TextUtils.isEmpty((CharSequence)scope.getScopeData())) continue;
            String scopeDataWithScopeNameString = null;
            try {
                scopeDataWithScopeNameString = this.generateScopeDataStringWithScopeName(scope);
            }
            catch (JSONException e) {
                MAPLog.e(LOG_TAG, "Error create JSON scope data object");
                throw new AuthError("Error create JSON scope data object", AuthError.ERROR_TYPE.ERROR_JSON);
            }
            parameters.add((Pair<String, String>)new Pair((Object)SCOPE_DATA, (Object)scopeDataWithScopeNameString));
        }
        parameters.add(new Pair((Object)APP_CLIENT_ID_PARAM, (Object)this.mClientId));
        return parameters;
    }

    @Override
    protected void logRequest() {
        MAPLog.i(LOG_TAG, "Executing code pair generation");
    }

    @Override
    protected CreateCodePairResponse generateResponse(HttpResponse httpResponse) {
        return new CreateCodePairResponse(httpResponse, this.mAppId, ScopeUtils.getScopeNamesFromScopeArray(this.mScopes));
    }

    private String generateScopeDataStringWithScopeName(Scope scope) throws JSONException {
        JSONObject scopeData = new JSONObject(scope.getScopeData());
        JSONObject scopeDataWithScopeName = new JSONObject();
        scopeDataWithScopeName.put(scope.getScopeName(), (Object)scopeData);
        return scopeDataWithScopeName.toString();
    }
}

