/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import android.util.Pair;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractPandaGetRequest;
import com.amazon.identity.auth.device.endpoint.HttpResponse;
import com.amazon.identity.auth.device.endpoint.ProfileResponse;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileRequest
extends AbstractPandaGetRequest<ProfileResponse> {
    private static final String LOG_TAG = ProfileRequest.class.getName();
    private static final String PROFILE_ENDPOINT = "/user/profile";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String AUTHORIZATION = "Authorization";
    protected static final String API_PREFIX_DEVO_SANDBOX = "api-sandbox.integ";
    protected static final String API_PREFIX_PRE_PROD_SANDBOX = "api.sandbox";
    protected static final String API_PREFIX_PROD_SANDBOX = "api.sandbox";
    private String authzToken;
    private boolean sandboxMode;

    public ProfileRequest(Bundle options, String authzToken, Context context, AppInfo appInfo) {
        super(context, appInfo);
        this.authzToken = authzToken;
        if (options != null) {
            this.sandboxMode = options.getBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, false);
        }
    }

    @Override
    protected ProfileResponse generateResponse(HttpResponse httpResponse) {
        return new ProfileResponse(httpResponse);
    }

    @Override
    protected List<Pair<String, String>> getExtraParameters() {
        return new ArrayList<Pair<String, String>>();
    }

    @Override
    protected String getEndPoint() {
        return PROFILE_ENDPOINT;
    }

    @Override
    protected List<Pair<String, String>> getExtraHeaders() {
        ArrayList<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();
        headers.add(new Pair((Object)AUTHORIZATION, (Object)(BEARER_PREFIX + this.authzToken)));
        return headers;
    }

    @Override
    protected boolean isSandboxEnabled() {
        return this.sandboxMode;
    }

    @Override
    protected void logRequest() {
        MAPLog.pii(LOG_TAG, "Executing profile request", "accessToken=" + this.authzToken);
    }
}

