/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidGrantAuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.dataobject.CodePair;
import com.amazon.identity.auth.device.dataobject.Scope;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.endpoint.AbstractPandaRequest;
import com.amazon.identity.auth.device.endpoint.CreateCodePairRequest;
import com.amazon.identity.auth.device.endpoint.CreateCodePairResponse;
import com.amazon.identity.auth.device.endpoint.OauthCodeForTokenRequest;
import com.amazon.identity.auth.device.endpoint.OauthCodeForTokenResponse;
import com.amazon.identity.auth.device.endpoint.OauthTokenForCodePairRequest;
import com.amazon.identity.auth.device.endpoint.OauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.OauthTokenResponse;
import com.amazon.identity.auth.device.endpoint.ProfileRequest;
import com.amazon.identity.auth.device.endpoint.ProfileResponse;
import com.amazon.identity.auth.device.endpoint.Response;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerCommunication {
    private static final String LOG_TAG = ServerCommunication.class.getName();

    public AuthorizationToken[] getAuthorizationTokens(RefreshAtzToken refreshAtzToken, String directedId, String[] scopes, Context context, Bundle options, AppInfo appInfo) throws IOException, AuthError {
        MAPLog.i(LOG_TAG, "getAuthorizationTokens : appId=" + appInfo.getAppFamilyId() + ", scopes=" + Arrays.toString(scopes));
        ServerCommunication.checkNetwork(context);
        OauthTokenRequest request = new OauthTokenRequest(context, refreshAtzToken, appInfo);
        try {
            OauthTokenResponse response = (OauthTokenResponse)request.submit();
            response.parse();
            return response.getAtzTokens();
        }
        catch (InvalidGrantAuthError e) {
            MAPLog.e(LOG_TAG, "Invalid grant request given to the server. Cleaning up local state");
            DatabaseHelper.clearAuthorizationState(context);
            throw e;
        }
    }

    public AuthorizationToken[] getTokensFromCode(String code, String redirectUri, String[] scopes, String directedId, AppInfo appInfo, Context context) throws IOException, AuthError {
        return this.getTokensFromCode(code, null, redirectUri, scopes, directedId, context, appInfo);
    }

    public AuthorizationToken[] getTokensFromCode(String code, String codeVerifier, String redirectUri, String[] scopes, String directedId, Context context, AppInfo appInfo) throws IOException, AuthError {
        MAPLog.i(LOG_TAG, "getTokensFromCode : appId=" + appInfo.getAppFamilyId() + ", scopes=" + Arrays.toString(scopes));
        ServerCommunication.checkNetwork(context);
        OauthCodeForTokenRequest request = new OauthCodeForTokenRequest(code, codeVerifier, redirectUri, directedId, appInfo, context);
        OauthCodeForTokenResponse response = (OauthCodeForTokenResponse)request.submit();
        response.parse();
        return response.getAtzTokens();
    }

    public CodePair getCodePair(Scope[] scopes, Context context, AppInfo appInfo) throws IOException, AuthError {
        ServerCommunication.checkNetwork(context);
        CreateCodePairRequest request = new CreateCodePairRequest(context, appInfo, scopes);
        CreateCodePairResponse response = (CreateCodePairResponse)request.submit();
        response.parse();
        return response.getCodePair();
    }

    public AuthorizationToken[] getTokensFromCodePair(String userCode, String deviceCode, Context context, AppInfo appInfo) throws IOException, AuthError {
        ServerCommunication.checkNetwork(context);
        OauthTokenForCodePairRequest request = new OauthTokenForCodePairRequest(userCode, deviceCode, appInfo, context);
        OauthTokenResponse response = (OauthTokenResponse)request.submit();
        response.parse();
        return response.getAtzTokens();
    }

    @SuppressLint(value={"MissingPermission"})
    private static void checkNetwork(Context context) throws IOException {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null || cm.getActiveNetworkInfo() == null) {
            throw new IOException("Network is unavailable");
        }
    }

    public JSONObject getProfile(Context context, String authzToken, Bundle options, AppInfo appInfo) throws AuthError, IOException {
        ServerCommunication.checkNetwork(context);
        ProfileRequest request = new ProfileRequest(options, authzToken, context, appInfo);
        ProfileResponse response = (ProfileResponse)request.submit();
        response.parse();
        return response.getProfileResponse();
    }

    public <T extends Response> T executeRequest(AbstractPandaRequest<T> request, Context context) throws IOException, AuthError {
        ServerCommunication.checkNetwork(context);
        Object response = request.submit();
        response.parse();
        return response;
    }
}

