/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.content.Context;
import android.net.Uri;
import com.amazon.identity.auth.device.interactive.InteractiveListener;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.workflow.WorkflowCancellation;
import java.util.Collections;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AggregateInteractiveListener<T extends InteractiveListener<S, U, V>, S, U, V>
implements InteractiveListener<S, U, V> {
    private String requestType;
    private Set<T> listeners;

    public AggregateInteractiveListener(String requestType, Set<T> listeners) {
        this.requestType = requestType;
        this.listeners = listeners == null ? Collections.emptySet() : listeners;
        for (InteractiveListener listener : this.listeners) {
            if (requestType.equals(listener.getRequestType())) continue;
            throw new IllegalStateException("AggregateInteractiveListener created for request type \"" + requestType + "\" but received listener with request type \"" + listener.getRequestType() + "\"");
        }
    }

    @Override
    public void onSuccess(S result) {
        for (InteractiveListener listener : this.listeners) {
            listener.onSuccess(result);
        }
    }

    @Override
    public void onCancel(U cause) {
        for (InteractiveListener listener : this.listeners) {
            listener.onCancel(cause);
        }
    }

    @Override
    public void onError(V error) {
        for (InteractiveListener listener : this.listeners) {
            listener.onError(error);
        }
    }

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public void onRequestCompletion(Context context, InteractiveRequestRecord request, Uri uri) {
        for (InteractiveListener listener : this.listeners) {
            listener.onRequestCompletion(context, request, uri);
        }
    }

    @Override
    public void onRequestError(Context context, InteractiveRequestRecord request, Exception e) {
        for (InteractiveListener listener : this.listeners) {
            listener.onRequestError(context, request, e);
        }
    }

    @Override
    public void onRequestCancel(Context context, InteractiveRequestRecord request, WorkflowCancellation cancellation) {
        for (InteractiveListener listener : this.listeners) {
            listener.onRequestCancel(context, request, cancellation);
        }
    }
}

