/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.interactive.InteractiveState;
import com.amazon.identity.auth.device.interactive.InteractiveStateFragment;
import com.amazon.identity.auth.device.interactive.RequestSource;
import com.amazon.identity.auth.device.interactive.WorkflowSupportFragment;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.lang.ref.WeakReference;

public final class RequestSourceSupportFragmentWrapper
implements RequestSource {
    private static final String LOG_TAG = RequestSourceSupportFragmentWrapper.class.getName();
    private final WeakReference<Fragment> fragmentReference;

    public RequestSourceSupportFragmentWrapper(Fragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException("fragment must be non-null");
        }
        this.fragmentReference = new WeakReference<Fragment>(fragment);
    }

    public void onStartRequest(InteractiveRequestRecord request) {
        this.getInteractiveStateAddingRequest(request);
    }

    public InteractiveState getInteractiveState() {
        return this.getInteractiveStateAddingRequest(null);
    }

    private InteractiveState getInteractiveStateAddingRequest(InteractiveRequestRecord request) {
        Fragment fragment = (Fragment)this.fragmentReference.get();
        if (fragment != null) {
            FragmentManager fragmentManager = fragment.getFragmentManager();
            try {
                InteractiveStateFragment stateFragment = (InteractiveStateFragment)fragmentManager.findFragmentByTag(InteractiveStateFragment.TAG_ID);
                if (stateFragment == null) {
                    WorkflowSupportFragment workflowFragment = new WorkflowSupportFragment();
                    fragmentManager.beginTransaction().add((Fragment)workflowFragment, InteractiveStateFragment.TAG_ID).commit();
                    stateFragment = workflowFragment;
                }
                if (request != null) {
                    Bundle fragmentWrapper = new Bundle();
                    fragmentManager.putFragment(fragmentWrapper, "wrappedFragment", fragment);
                    request.setFragmentWrapper(fragmentWrapper);
                    stateFragment.getState().onRequestStart(request);
                }
                return stateFragment.getState();
            }
            catch (ClassCastException e) {
                MAPLog.e(LOG_TAG, "Found an invalid fragment looking for fragment with tag " + InteractiveStateFragment.TAG_ID + ". Please use a different fragment tag.", e);
            }
        } else {
            MAPLog.e(LOG_TAG, "Failed to get InteractiveState on a garbage-collected Fragment");
        }
        return null;
    }

    public Object getBackingObject() {
        return this.fragmentReference.get();
    }

    public Context getContext() {
        return ((Fragment)this.fragmentReference.get()).getActivity();
    }

    public boolean isHookNeededOnUIResume() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fragmentReference == null || this.fragmentReference.get() == null ? 0 : ((Fragment)this.fragmentReference.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestSourceSupportFragmentWrapper other = (RequestSourceSupportFragmentWrapper)obj;
        if (this.fragmentReference == null) {
            if (other.fragmentReference != null) {
                return false;
            }
        } else {
            if (other.fragmentReference == null) {
                return false;
            }
            if (this.fragmentReference.get() == null ? other.fragmentReference.get() != null : !((Fragment)this.fragmentReference.get()).equals(other.fragmentReference.get())) {
                return false;
            }
        }
        return true;
    }
}

