/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.thread;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public final class ThreadUtils {
    private static int sThreadNum = 0;
    public static final Executor THREAD_POOL = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new Thread(r, "AmazonAuthorzationLibrary#" + ++sThreadNum);
        }
    });

    private ThreadUtils() {
    }

    public static boolean isRunningOnMainThread() {
        return Looper.getMainLooper() != null && Looper.getMainLooper() == Looper.myLooper();
    }

    public static void runOnMainThread(Runnable command) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(command);
    }

    public static void submitToBackgroundThread(Runnable command) {
        THREAD_POOL.execute(command);
    }

    public static void runOffMainThread(Runnable command) {
        if (!ThreadUtils.isRunningOnMainThread()) {
            command.run();
        } else {
            ThreadUtils.submitToBackgroundThread(command);
        }
    }
}

