/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import android.util.Base64;
import com.amazon.identity.auth.device.utils.SignatureUtil;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.json.JSONException;
import org.json.JSONObject;

public class JWTDecoder {
    private static final String LOG_TAG = JWTDecoder.class.getName();
    private static final String JWT_SPLITTER = "[.]";
    private static final String FAILED_TO_DECODE = "Failed to decode: ";
    private static final String CHAR_SET = "UTF-8";

    public JSONObject decode(String jwt) {
        if (jwt == null) {
            return null;
        }
        try {
            String[] tokenParts = this.getTokenParts(jwt.trim());
            this.verifySignature(tokenParts);
            JSONObject payload = new JSONObject(this.decodeBase64ToString(tokenParts[JWT_SECTION.PAYLOAD.ordinal()]));
            return payload;
        }
        catch (UnsupportedEncodingException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (JSONException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (InvalidKeyException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (NoSuchProviderException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (SignatureException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (CertificateException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (IOException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (SecurityException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            MAPLog.w(LOG_TAG, FAILED_TO_DECODE + e.getMessage());
        }
        return null;
    }

    private String[] getTokenParts(String jwt) {
        assert (jwt != null);
        String[] toReturn = jwt.split(JWT_SPLITTER);
        if (toReturn.length != 3) {
            throw new IllegalArgumentException("Invalid JWT format");
        }
        return toReturn;
    }

    private String decodeBase64ToString(String base64String) throws UnsupportedEncodingException {
        byte[] byteData = this.decodeBase64ToBytes(base64String);
        return new String(byteData, CHAR_SET);
    }

    private byte[] decodeBase64ToBytes(String base64String) throws UnsupportedEncodingException {
        return Base64.decode((byte[])base64String.trim().getBytes(CHAR_SET), (int)0);
    }

    private void verifySignature(String[] tokenParts) throws InvalidKeyException, NoSuchProviderException, SignatureException, NoSuchAlgorithmException, CertificateException, IOException {
        byte[] data = (tokenParts[JWT_SECTION.HEADER.ordinal()].trim() + "." + tokenParts[JWT_SECTION.PAYLOAD.ordinal()].trim()).getBytes(CHAR_SET);
        byte[] signature = this.decodeBase64ToBytes(tokenParts[JWT_SECTION.SIGNATURE.ordinal()]);
        if (!this.verifySignatureWithRsaSha256(signature, data, SignatureUtil.getAmazonPublicCertificate())) {
            throw new SecurityException("Decoding fails: signature mismatch!");
        }
        MAPLog.i(LOG_TAG, "Signature match!");
    }

    private boolean verifySignatureWithRsaSha256(byte[] signature, byte[] data, Certificate cert) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature signer = Signature.getInstance("SHA256withRSA");
        signer.initVerify(cert);
        signer.update(data);
        return signer.verify(signature);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JWT_SECTION {
        HEADER,
        PAYLOAD,
        SIGNATURE;

    }
}

