/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import android.content.Context;
import android.os.RemoteException;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.AmazonAuthorizationServiceInterface;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.map.device.utils.MAPLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LWAServiceWrapper<Result> {
    private static final String LOG_TAG = LWAServiceWrapper.class.getName();
    private static final int SERVICE_BINDING_RETRY_ATTEMPTS = 3;

    public final Result execute(Context context, ThirdPartyServiceHelper helper) throws AuthError {
        RemoteException serviceFailure = null;
        Result result = null;
        for (int i = 0; i <= 3; ++i) {
            try {
                boolean forceServiceRefresh = i == 3;
                AmazonAuthorizationServiceInterface service = helper.getRemoteAndroidService(context, forceServiceRefresh);
                if (service == null) continue;
                result = this.doWork(context, service);
                ThirdPartyServiceHelper.unbind(context);
                return result;
            }
            catch (RemoteException e) {
                MAPLog.e(LOG_TAG, "RemoteException", e);
                ThirdPartyServiceHelper.unbind(context);
                serviceFailure = e;
            }
        }
        if (result == null && serviceFailure != null) {
            throw new AuthError("Service Failure", serviceFailure, AuthError.ERROR_TYPE.ERROR_THREAD);
        }
        return result;
    }

    protected abstract Result doWork(Context var1, AmazonAuthorizationServiceInterface var2) throws AuthError, RemoteException;
}

