/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.Scope;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MAPUtils {
    private static final String AMAZON_HOST = ".amazon.";
    private static final String PROTOCOL = "http";
    private static final String PATH_AP = "/ap/";
    private static final String PATH_GP = "/gp/yourstore/home";
    private static final String PATH_AP_FORGOT_PASSWORD = "/ap/forgotpassword";
    private static final String HOST_TYPE = "host.type";
    private static final String LOG_TAG = MAPUtils.class.getName();
    private static SQLiteDatabase MAPdatabase = null;

    private MAPUtils() throws Exception {
        throw new Exception("This class is not instantiable!");
    }

    public static synchronized SQLiteDatabase getMAPdatabase(Context context) {
        if (MAPdatabase == null) {
            try {
                MAPdatabase = new DatabaseHelper(context).getWritableDatabase();
            }
            catch (SQLiteException e) {
                MAPUtils.deleteDatabase(context);
                MAPdatabase = new DatabaseHelper(context).getWritableDatabase();
            }
        }
        return MAPdatabase;
    }

    public static SQLiteDatabase deleteDatabase(Context context) {
        try {
            MAPLog.d(LOG_TAG, "deleteDatabase so we can create it from scratch");
            boolean result = context.deleteDatabase("MAPDataStore.db");
            MAPLog.d(LOG_TAG, "deleteDatabase was successful : " + result);
        }
        catch (SQLiteException e) {
            MAPLog.d(LOG_TAG, "deleteDatabase exception: " + e.getMessage());
        }
        return MAPdatabase;
    }

    public static void resetDatabaseInstance() {
        MAPdatabase = null;
    }

    public static String getDeviceId() {
        return "some-device-id";
    }

    public static String toDelimitedString(String[] ary, String delimiter) {
        String to_return;
        if (ary != null && ary.length > 0) {
            to_return = "";
            for (int i = 0; i < ary.length; ++i) {
                to_return = to_return + ary[i].trim() + (i == ary.length - 1 ? "" : delimiter);
            }
        } else {
            to_return = null;
        }
        return to_return;
    }

    public static String[] toStringArray(String str, String delimiter) {
        return str != null && str.trim().length() > 0 ? str.trim().split("[" + delimiter + "]") : null;
    }

    public static Set<String> getSetDifference(String[] setA, String[] setB) {
        if (setA == null) {
            return new HashSet<String>();
        }
        if (setB == null) {
            return new HashSet<String>(Arrays.asList(setA));
        }
        HashSet<String> to_return = new HashSet<String>(Arrays.asList(setA));
        to_return.removeAll(Arrays.asList(setB));
        return to_return;
    }

    public static boolean contains(String[] ary, String str) {
        if (ary == null) {
            return false;
        }
        for (String tmp : ary) {
            if (!tmp.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean areScopesRemoteAndValid(AppInfo appInfo, String[] scopes) {
        return MAPUtils.areScopesValid(appInfo, scopes, SCOPE_MODIFIER.REMOTE);
    }

    public static boolean areScopesLocalAndValid(AppInfo appInfo, String[] scopes) {
        return MAPUtils.areScopesValid(appInfo, scopes, SCOPE_MODIFIER.LOCAL);
    }

    public static boolean areScopesValid(AppInfo appInfo, String[] scopes) {
        return MAPUtils.areScopesValid(appInfo, scopes, SCOPE_MODIFIER.ALL);
    }

    private static boolean areScopesValid(AppInfo appInfo, String[] scopes, SCOPE_MODIFIER modifier) {
        MAPLog.i(LOG_TAG, "areScopesValid : modifier=" + modifier.name() + " scopes=" + Arrays.toString(scopes));
        if (scopes == null || scopes.length == 0) {
            MAPLog.w(LOG_TAG, "Scopes are invalid: array is either null or empty");
            return false;
        }
        if (appInfo == null || appInfo.getAllowedScopes() == null) {
            MAPLog.w(LOG_TAG, "Scopes are invalid: either appInfo is null or allowedScopes is null");
            return false;
        }
        HashSet<String> allowedScopeSet = new HashSet<String>(Arrays.asList(appInfo.getAllowedScopes()));
        MAPLog.i(LOG_TAG, "allowedScopeSet : " + allowedScopeSet);
        for (String scope : scopes) {
            if (scope == null || !allowedScopeSet.contains(scope)) {
                MAPLog.w(LOG_TAG, "Invalid scope: " + scope + " (it's either null or not part of the allowed set)");
                return false;
            }
            if (modifier == SCOPE_MODIFIER.REMOTE && Scope.isLocal(scope)) {
                MAPLog.w(LOG_TAG, "Invalid scope: " + scope + " is local!");
                return false;
            }
            if (modifier != SCOPE_MODIFIER.LOCAL || Scope.isLocal(scope)) continue;
            MAPLog.w(LOG_TAG, "Invalid scope: " + scope + " is remote!");
        }
        return true;
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            String appendString = Integer.toHexString(0xFF & data[i]);
            if (appendString.length() == 1) {
                hexString.append("0");
            }
            hexString.append(appendString);
        }
        return hexString.toString();
    }

    public static boolean isMAPUrl(String url) {
        String host;
        URL aURL;
        if (url == null) {
            MAPLog.i(LOG_TAG, "URL is null");
            return false;
        }
        try {
            aURL = new URL(url);
        }
        catch (MalformedURLException e) {
            MAPLog.pii(LOG_TAG, "MalformedURLException", " url=" + url);
            return false;
        }
        String protocol = aURL.getProtocol();
        if (!TextUtils.isEmpty((CharSequence)protocol) && protocol.contains(PROTOCOL) && !TextUtils.isEmpty((CharSequence)(host = aURL.getHost())) && host.contains(AMAZON_HOST)) {
            String path = aURL.getPath();
            boolean isPathEmpty = TextUtils.isEmpty((CharSequence)path);
            boolean pathStartsWithAP = path.startsWith(PATH_AP);
            boolean pathEqualsGP = path.equals(PATH_GP);
            boolean pathEqualsAPForgotPassword = path.equals(PATH_AP_FORGOT_PASSWORD);
            MAPLog.d(LOG_TAG, " isEmpty=" + isPathEmpty + "startsWithAP=" + pathStartsWithAP + "equalsGP=" + pathEqualsGP + "equalsForgotPassword=" + pathEqualsAPForgotPassword);
            if (!isPathEmpty && (pathStartsWithAP && !pathEqualsAPForgotPassword || pathEqualsGP)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isDevo(Context context) {
        if (context == null) {
            return false;
        }
        String packageName = context.getPackageName();
        return MAPUtils.getHostType(context, packageName).equalsIgnoreCase("development");
    }

    public static String getHostType(Context context, String packageName) {
        String hostType = "www";
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
            if (appInfo.metaData != null && appInfo.metaData.containsKey(HOST_TYPE)) {
                hostType = appInfo.metaData.getString(HOST_TYPE);
                MAPLog.pii(LOG_TAG, "Host Type", "hostType=" + hostType + " package=" + packageName);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.d(LOG_TAG, "No host type found in package " + packageName);
        }
        return hostType;
    }

    public static String getVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.w(LOG_TAG, "Unable to get verison info from app" + e.getMessage());
            return "N/A";
        }
    }

    public static String getAppName(Context context) {
        ApplicationInfo ai;
        PackageManager pm = context.getApplicationContext().getPackageManager();
        try {
            ai = pm.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        return ai != null ? pm.getApplicationLabel(ai) : context.getPackageName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SCOPE_MODIFIER {
        LOCAL,
        REMOTE,
        ALL;

    }
}

