/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.amazon.identity.auth.device.utils.HashAlgorithm;
import com.amazon.identity.auth.device.utils.MAPUtils;
import com.amazon.identity.auth.device.utils.SignatureUtil;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"PackageManagerGetSignatures"})
public class PackageSignatureUtil {
    private static final String LOG_TAG = PackageSignatureUtil.class.getName();

    public static List<String> getAllSignaturesFor(String packageName, HashAlgorithm algorithm, Context context) {
        ArrayList<String> signatureList = new ArrayList<String>();
        Signature[] signatures = PackageSignatureUtil.getAndroidSignaturesFor(packageName, context);
        if (signatures == null) {
            MAPLog.d(LOG_TAG, " appSignature is null. pkg=" + packageName);
            return signatureList;
        }
        MAPLog.i(LOG_TAG, "num sigs = " + signatures.length);
        for (Signature sig : signatures) {
            String fingerprint = null;
            try {
                fingerprint = PackageSignatureUtil.getSignatureFingerprint(sig, algorithm);
                signatureList.add(fingerprint.toLowerCase(Locale.US));
            }
            catch (Exception e) {
                MAPLog.e(LOG_TAG, "Encountered error while finding signatures for " + packageName, e);
            }
            MAPLog.pii(LOG_TAG, "Fingerprint checking", "fingerprint = " + fingerprint);
        }
        return signatureList;
    }

    public static String getSignatureFingerprint(Signature sig, HashAlgorithm hashingAlgorithm) throws IOException, CertificateException, NoSuchAlgorithmException {
        Certificate cert = SignatureUtil.getCertificateFromByteArray(sig.toByteArray());
        return MAPUtils.toHexString(PackageSignatureUtil.getFingerprint(hashingAlgorithm, cert.getEncoded()));
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private static Signature[] getAndroidSignaturesFor(String packageName, Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo pkgInfo = null;
        if (packageManager == null) {
            MAPLog.d(LOG_TAG, "Can't find app signatures as pkgMgr is null ");
            return null;
        }
        try {
            pkgInfo = packageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.d(LOG_TAG, "packageName not found for package " + packageName);
        }
        if (pkgInfo == null) {
            MAPLog.d(LOG_TAG, "Can't find app signatures as pkgMgr is null ");
            return null;
        }
        return pkgInfo.signatures;
    }

    private static byte[] getFingerprint(HashAlgorithm algorithm, byte[] data) throws NoSuchAlgorithmException {
        assert (data != null);
        return MessageDigest.getInstance(algorithm.getAlgorithmName()).digest(data);
    }
}

