/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.workflow;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.RequestManager;
import com.amazon.identity.auth.device.ResponseManager;
import com.amazon.identity.auth.device.api.workflow.RequestContext;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.util.Locale;

@SuppressLint(value={"Registered"})
public final class WorkflowActivity
extends Activity {
    private static final String LOG_TAG = WorkflowActivity.class.getName();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        MAPLog.d(LOG_TAG, "onCreate");
        WorkflowActivity.handleResponseUri(this.getIntent().getData(), this, LOG_TAG);
        MAPLog.d(LOG_TAG, "finish");
        this.finish();
    }

    public static void handleResponseUri(Uri uri, Activity activity, String tag) {
        if (uri == null) {
            MAPLog.i(tag, "uri is null onCreate - closing activity");
        } else {
            try {
                if (RequestManager.isInteractiveRequest(uri)) {
                    MAPLog.d(tag, "Receiving response for interactive request");
                    String requestId = RequestManager.getRequestIdFromResponseUri(uri);
                    MAPLog.d(tag, "Receiving response for request " + requestId);
                    ResponseManager.getInstance().putPendingResponse(requestId, uri);
                    RequestContext requestContext = RequestManager.getInstance().getRequestContextForRequest(requestId);
                    if (requestContext != null && !requestContext.isHookNeededOnUIResume()) {
                        MAPLog.d(tag, String.format(Locale.ENGLISH, "Request %s is not hooked on UI resume, should be handled immediately", requestId));
                        requestContext.onResume();
                    }
                } else {
                    MAPLog.d(tag, "Receiving response for auth request");
                    if (!RequestManager.getInstance().handleResponse(uri, activity.getApplicationContext())) {
                        MAPLog.pii(tag, "Could not find active request for redirect URI", uri.toString());
                    }
                }
            }
            catch (AuthError e) {
                MAPLog.pii(tag, "Could not handle response URI", uri.toString(), e);
            }
        }
    }
}

