package com.nxp.vizncompanionapp.activities;


import android.support.test.espresso.ViewInteraction;
import android.support.test.rule.ActivityTestRule;
import android.support.test.runner.AndroidJUnit4;
import android.test.suitebuilder.annotation.LargeTest;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;

import com.nxp.vizncompanionapp.R;
import com.nxp.vizncompanionapp.utility.AppConstant;
import com.nxp.vizncompanionapp.utility.PreferencesHelper;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

import static android.support.test.InstrumentationRegistry.getInstrumentation;
import static android.support.test.espresso.Espresso.onView;
import static android.support.test.espresso.Espresso.openActionBarOverflowOrOptionsMenu;
import static android.support.test.espresso.action.ViewActions.click;
import static android.support.test.espresso.assertion.ViewAssertions.matches;
import static android.support.test.espresso.matcher.ViewMatchers.isDisplayed;
import static android.support.test.espresso.matcher.ViewMatchers.withClassName;
import static android.support.test.espresso.matcher.ViewMatchers.withContentDescription;
import static android.support.test.espresso.matcher.ViewMatchers.withId;
import static android.support.test.espresso.matcher.ViewMatchers.withText;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.is;

@LargeTest
@RunWith(AndroidJUnit4.class)
public class SplashActivityTest {

    @Rule
    public ActivityTestRule<SplashActivity> mActivityTestRule = new ActivityTestRule<>(SplashActivity.class);


    @Test
    public void splashActivityTest2() {
        // Added a sleep statement to match the app's execution delay.
        // The recommended way to handle such scenarios is to use Espresso idling resources:
        // https://google.github.io/android-testing-support-library/docs/espresso/idling-resource/index.html
        PreferencesHelper helper = new PreferencesHelper(mActivityTestRule.getActivity());
        boolean value = helper.loadSavedBooleanPreferences(AppConstant.INSTANCE.getSHARED_KEY_LAUNCH_INFO_SCRREN());
        Log.e("TAG", "splashActivityTest2: "+value );
        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

        if(!value) {

            ViewInteraction viewGroup = onView(
                    allOf(withId(R.id.toolbar),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            0),
                                    0),
                            isDisplayed()));
            viewGroup.check(matches(isDisplayed()));


            ViewInteraction textView = onView(
                    allOf(withText("your device includes access to Alexa.\nConnect your Amazon account to\naccess personalized features.\n\nAlexa allows you to use your voice to play\nmusic and get news, sports scores,\nweather and more-all Hans-free All\nyou have to do is ask Alexa."),
                            isDisplayed()));
            textView.check(matches(isDisplayed()));

            ViewInteraction button = onView(
                    allOf(withId(R.id.btnNext),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button.check(matches(isDisplayed()));


            ViewInteraction appCompatButton = onView(
                    allOf(withId(R.id.btnNext), withText("Next"),
                            childAtPosition(
                                    childAtPosition(
                                            withClassName(is("android.support.design.widget.CoordinatorLayout")),
                                            1),
                                    2),
                            isDisplayed()));
            appCompatButton.perform(click());


/*            ViewInteraction button4 = onView(
                    allOf(withId(R.id.btnDiscover),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button4.check(matches(isDisplayed()));
*/

        } else {

            ViewInteraction viewGroup = onView(
                    allOf(withId(R.id.toolbar),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            0),
                                    0),
                            isDisplayed()));
            viewGroup.check(matches(isDisplayed()));

/*            ViewInteraction button4 = onView(
                    allOf(withId(R.id.btnDiscover),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button4.check(matches(isDisplayed()));
*/

            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            openActionBarOverflowOrOptionsMenu(getInstrumentation().getTargetContext());

            ViewInteraction appCompatTextView = onView(
                    allOf(withId(R.id.title), withText("Info"),
                            childAtPosition(
                                    childAtPosition(
                                            withClassName(is("android.support.v7.view.menu.ListMenuItemView")),
                                            0),
                                    0),
                            isDisplayed()));
            appCompatTextView.perform(click());

            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            ViewInteraction button = onView(
                    allOf(withId(R.id.btnNext),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button.check(matches(isDisplayed()));

            ViewInteraction appCompatImageButton = onView(
                    allOf(withContentDescription("Navigate up"),
                            childAtPosition(
                                    allOf(withId(R.id.toolbar),
                                            childAtPosition(
                                                    withClassName(is("android.support.design.widget.AppBarLayout")),
                                                    0)),
                                    1),
                            isDisplayed()));
            appCompatImageButton.perform(click());

/*            ViewInteraction button2 = onView(
                    allOf(withId(R.id.btnDiscover),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button2.check(matches(isDisplayed()));
*/
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            openActionBarOverflowOrOptionsMenu(getInstrumentation().getTargetContext());

            ViewInteraction appCompatTextView2 = onView(
                    allOf(withId(R.id.title), withText("Info"),
                            childAtPosition(
                                    childAtPosition(
                                            withClassName(is("android.support.v7.view.menu.ListMenuItemView")),
                                            0),
                                    0),
                            isDisplayed()));
            appCompatTextView2.perform(click());


            ViewInteraction button5 = onView(
                    allOf(withId(R.id.btnNext),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button5.check(matches(isDisplayed()));

            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            ViewInteraction appCompatButton2 = onView(
                    allOf(withId(R.id.btnNext), withText("DONE"),
                            childAtPosition(
                                    childAtPosition(
                                            withClassName(is("android.support.design.widget.CoordinatorLayout")),
                                            1),
                                    2),
                            isDisplayed()));
            appCompatButton2.perform(click());
/*
            ViewInteraction button3 = onView(
                    allOf(withId(R.id.btnDiscover),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button3.check(matches(isDisplayed()));
*/

            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

/*
            ViewInteraction appCompatButton3 = onView(
                    allOf(withId(R.id.btnDiscover), withText("Discover"),
                            childAtPosition(
                                    childAtPosition(
                                            withClassName(is("android.support.design.widget.CoordinatorLayout")),
                                            1),
                                    2),
                            isDisplayed()));
            appCompatButton3.perform(click());
*/
            Log.e("TAG", "splashActivityTest2: "+"Clicked.." );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+10 );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+20 );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+30 );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+40 );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+50 );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+60 );

            try {
                Thread.sleep(10000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            Log.e("TAG", "splashActivityTest2: "+70 );

            ViewInteraction textView2 = onView(
                    allOf(withId(R.id.md_content), withText("No Device Found!"),
                            childAtPosition(
                                    allOf(withId(R.id.md_contentScrollView),
                                            childAtPosition(
                                                    IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                                    1)),
                                    0),
                            isDisplayed()));
            textView2.check(matches(isDisplayed()));

            ViewInteraction textView3 = onView(
                    allOf(withId(R.id.md_buttonDefaultNegative), withText("CANCEL"),
                            childAtPosition(
                                    childAtPosition(
                                            withId(android.R.id.content),
                                            0),
                                    2),
                            isDisplayed()));
            textView3.check(matches(isDisplayed()));

            ViewInteraction textView4 = onView(
                    allOf(withId(R.id.md_buttonDefaultPositive), withText("TRY AGAIN"),
                            childAtPosition(
                                    childAtPosition(
                                            withId(android.R.id.content),
                                            0),
                                    3),
                            isDisplayed()));
            textView4.check(matches(isDisplayed()));

            ViewInteraction mDButton = onView(
                    allOf(withId(R.id.md_buttonDefaultNegative), withText("Cancel"),
                            childAtPosition(
                                    childAtPosition(
                                            withId(android.R.id.content),
                                            0),
                                    3),
                            isDisplayed()));
            mDButton.perform(click());
/*
            ViewInteraction button6 = onView(
                    allOf(withId(R.id.btnDiscover),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button6.check(matches(isDisplayed()));
*/
            /*try {
                Thread.sleep(60000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            ViewInteraction viewGroup2 = onView(
                    allOf(childAtPosition(
                            allOf(withId(android.R.id.content),
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.widget.LinearLayout.class),
                                            0)),
                            0),
                            isDisplayed()));
            viewGroup2.check(matches(isDisplayed()));

            ViewInteraction textView2 = onView(
                    allOf(withId(R.id.md_content), withText("No Device Found!"),
                            childAtPosition(
                                    allOf(withId(R.id.md_contentScrollView),
                                            childAtPosition(
                                                    IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                                    1)),
                                    0),
                            isDisplayed()));
            textView2.check(matches(isDisplayed()));

            ViewInteraction textView3 = onView(
                    allOf(withId(R.id.md_buttonDefaultNegative), withText("CANCEL"),
                            childAtPosition(
                                    childAtPosition(
                                            withId(android.R.id.content),
                                            0),
                                    2),
                            isDisplayed()));
            textView3.check(matches(isDisplayed()));

            ViewInteraction textView4 = onView(
                    allOf(withId(R.id.md_buttonDefaultPositive), withText("TRY AGAIN"),
                            childAtPosition(
                                    childAtPosition(
                                            withId(android.R.id.content),
                                            0),
                                    3),
                            isDisplayed()));
            textView4.check(matches(isDisplayed()));

            ViewInteraction mDButton = onView(
                    allOf(withId(R.id.md_buttonDefaultNegative), withText("Cancel"),
                            childAtPosition(
                                    childAtPosition(
                                            withId(android.R.id.content),
                                            0),
                                    3),
                            isDisplayed()));
            mDButton.perform(click());

            ViewInteraction button6 = onView(
                    allOf(withId(R.id.btnDiscover),
                            childAtPosition(
                                    childAtPosition(
                                            IsInstanceOf.<View>instanceOf(android.view.ViewGroup.class),
                                            1),
                                    2),
                            isDisplayed()));
            button6.check(matches(isDisplayed()));*/
        }

    }

    private static Matcher<View> childAtPosition(
            final Matcher<View> parentMatcher, final int position) {

        return new TypeSafeMatcher<View>() {
            @Override
            public void describeTo(Description description) {
                description.appendText("Child at position " + position + " in parent ");
                parentMatcher.describeTo(description);
            }

            @Override
            public boolean matchesSafely(View view) {
                ViewParent parent = view.getParent();
                return parent instanceof ViewGroup && parentMatcher.matches(parent)
                        && view.equals(((ViewGroup) parent).getChildAt(position));
            }
        };
    }
}
