package com.nxp.vizncompanionapp.activities

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.support.v7.widget.LinearLayoutManager
import com.nxp.vizncompanionapp.R
import com.nxp.vizncompanionapp.adapters.ListAdapter
import com.nxp.vizncompanionapp.utility.PreferencesHelper
import com.nxp.vizncompanionapp.viewModel.DeviceViewModel
import kotlinx.android.synthetic.main.activity_discover.*
import kotlinx.android.synthetic.main.device_list_ip.*
import android.arch.lifecycle.Observer
import android.view.MenuItem
import com.nxp.vizncompanionapp.model.Device
import com.nxp.vizncompanionapp.utility.DisplayNotifications
import com.nxp.vizncompanionapp.utility.NetworkChangeReceiver

class DeviceIpActivity : AppCompatActivity()  {

    var adapter : ListAdapter? = null
    private var mDeviceViewModel: DeviceViewModel? = null
    private var currentDevice: Device? = null
    var preference: PreferencesHelper? = null
    private var mDisplayNotifications: DisplayNotifications = DisplayNotifications()

    /**
     * Object of NetworkChangeReceiver to start and stop timer
     */
    private val networkChangeReceiver = NetworkChangeReceiver()
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.device_list_ip)
        setSupportActionBar(toolbar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)

        adapter = ListAdapter(this)
        rvDeviceIpList.adapter = adapter
        rvDeviceIpList.layoutManager = LinearLayoutManager(this)

        // Get a new or existing ViewModel from the ViewModelProvider.
        mDeviceViewModel = ViewModelProviders.of(this).get(DeviceViewModel::class.java)

        // Add an observer on the LiveData returned by getAlphabetizedWords.
        // The onChanged() method fires when the observed data changes and the activity is
        // in the foreground.
        mDeviceViewModel?.getAllDevices()?.observe(this, Observer { devices ->
            // Update the cached copy of the words in the adapter.
            adapter?.setDevices(devices)
        })
        getDevice()
        //onClickListener()
    }

    fun getDevice(){
        mDeviceViewModel?.sendBroadcast(this)
        mDeviceViewModel?.loadDevices(this)
    }

    override fun onBackPressed() {
        super.onBackPressed()
        networkChangeReceiver.stopTimer()
        mDeviceViewModel?.stopSocket()
        mDeviceViewModel?.removeHandlerSend()
        mDeviceViewModel?.stopTimer()
        mDeviceViewModel?.removeHandlerRequest()
        finish()
        //overridePendingTransition(R.anim.slide_in_left, R.anim.slide_out_right)
    }

    override fun onResume() {
        super.onResume()
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        return if (item?.itemId == android.R.id.home) {
            onBackPressed()
            true
        } else {
            super.onOptionsItemSelected(item)
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        networkChangeReceiver.stopTimer()
        mDeviceViewModel?.stopSocket()
        mDeviceViewModel?.removeHandlerSend()
        mDeviceViewModel?.stopTimer()
        mDeviceViewModel?.removeHandlerRequest()
    }

}
