/**
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.nxp.vizncompanionapp.activities

import android.content.Intent
import android.support.v7.app.AppCompatActivity
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.provider.Settings
import com.nxp.vizncompanionapp.R
import com.nxp.vizncompanionapp.utility.AppConstant
import com.nxp.vizncompanionapp.utility.NetworkChangeReceiver
import kotlinx.android.synthetic.main.content_network_error.*

class NetworkErrorActivity : AppCompatActivity() {


    /**
     * Handler used to handle ui processing.
     */
    private var handler: Handler? = null
    /**
     * Run pre define event when its fulfill the condition
     */
    /**
     * Object of NetworkChangeReceiver to start and stop timer
     */
    private val networkChangeReceiver = NetworkChangeReceiver()

    /**
     * check wifi in connected or not
     */
    private val timetask = object : Runnable {
        override fun run() {
            if (AppConstant.IS_INTERNET) {
                AppConstant.IS_NETWORK_SCREEN_ON = false
                finishActivity()
            } else {
                handler?.postDelayed(this, 1000)
            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_network_error)
    }

    override fun onResume() {
        super.onResume()
        /* This code together with the one in onDestroy()
         * will make the screen be always on until this Activity gets destroyed. */
        networkChangeReceiver.setTimer(this)
        handler = Handler(Looper.getMainLooper())
        handler?.postDelayed(timetask, 1000)
        AppConstant.IS_NETWORK_SCREEN_ON = true

        onClickListeners()
    }

    /**
     * go to mobile device setting screen to enable wifi
     */
    private fun onClickListeners() {
        btn_wifi_connection.setOnClickListener {
            startActivity(Intent(Settings.ACTION_SETTINGS).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK))
        }
    }

    /**
     * finish this activity when mobile device got wifi connectivity
     */
    private fun finishActivity() {
        networkChangeReceiver.stopTimer()
        finish()
        AppConstant.IS_NETWORK_SCREEN_ON = false
    }

    override fun onBackPressed() {
    }

    override fun onDestroy() {
        networkChangeReceiver.stopTimer()
        super.onDestroy()
    }
}
