/**
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.nxp.vizncompanionapp.utility

object AppConstant {

    val SHARED_KEY_LAUNCH_INFO_SCRREN:String = "load_screen"
    val SHARED_KEY_WIFI_LOST: String = "WiFiLost"
    val SHARED_KEY_LINKING_PROCESS: String = "Linking process"
    val SHARED_KEY_NEVER_ASK_AGAIN_LOCATION_PERMISSION: String = "never_ask_again_permission_location"
    val UDP_PORT: Int = 8888
    val BROADCAST_MSG: String = "Hello"
    val DEVICE_CONFIRM_REQUEST_MSG = "ConfirmationRequest"
    val BROADCAST_ADDRESS: String = "255.255.255.255"
    val DEVICE_PRODUCT_ID: String = "productid"
    val DEVICE_DSN: String = "dsn"
    val DEVICE_CODE_CHALLENGE: String = "codechallenge"
    val DEVICE_METADATE: String = "metadata"
    val DEVICE_STATE: String = "state"
    val DEVICE_STATUS: String = "status"
    val DEVICE_AUTH_CODE: String = "AuthCode"
    val DEVICE_CLIENT_ID: String =  "ClientID"
    val DEVICE_REDIRECT_URL = "RedirectURI"
    val DEVICE_STATUS_LINKING: String = "Linking Account..."
    val DEVICE_STATUS_COMPLETE: String = "Complete"
    val DEVICE_STATUS_CONFIRM: String = "Confirm"
    val DEVICE_STATUS_ERROR: String = "Error occurred.Try Again..."
    val DEVICE_AMAZON_REQUEST: String = "amazon request"
    val DEVICE_AMAZON_RESPONSE: String = "amazon response"
    val DEVICE_SEND_AUTH_TO_PRODUCT: String = "sent Auth to Product"
    val DEVICE_STATUS_CONNECTION_COMPLETE: String = "connection complete"
    val DEVICE_STATUS_REGISTER_REQUEST: String = "registering request"
    val DEVICE_STATUS_REGISTER_RESPONSE: String = "registering response"
    val DEVICE_STATUS_MQTT_SUBSCRIBED: String = "mqtt subscribed"
    val DEVICE_STATUS_CONNECTION_ERROR: String = "error in connection"
    val DEVICE_STATE_CONFIRM_RESPONSE: String = "ConfirmationReply"
    val DEVICE_STATE_ALREADY_CONNECTED: String = "already connected"
    var IS_INTERNET: Boolean = false
    var IS_NETWORK_SCREEN_ON: Boolean = false
    val DEVICE_SCAN_TIMEOUT: Long = 90000
    val DEVICE_SEND_CRED_TIMEOUT: Long = 30000
    val DEVICE_RESPONSE_TIMEOUT: Long = 60000
    val BUTTON_TEXT: String = "DONE"
    val DEVICE_SERVICE_UUID = "3e9d2530-2f00-11e9-9602-a44cc81c989a"
    val DEVICE_WIFI_UUID = "3e9d2532-2f00-11e9-9602-a44cc81c989a"
    val BLE_SCAN_PERIOD: Long = 10000
    val NO_OF_BROADCAST: Int = 6
    val DEVICE_BROADCAST_TIMEOUT: Long = (NO_OF_BROADCAST * 5000).toLong()
}