/**
 * Copyright (c) 2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.nxp.vizncompanionapp.utility

import android.app.ActivityManager
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.net.ConnectivityManager
import android.os.AsyncTask
import android.os.Build
import com.nxp.vizncompanionapp.activities.NetworkErrorActivity
import java.io.IOException
import java.net.HttpURLConnection
import java.net.URL
import java.util.*

class NetworkChangeReceiver : BroadcastReceiver() {

    private var isInBackground = false
    private var context: Context? = null
    private var mTimer: Timer? = null
    var prefeernce: PreferencesHelper? = null

    override fun onReceive(context: Context?, intent: Intent?) {
        this.context = context
        this.isInBackground = isAppIsInBackground(context)
        if (context != null) {
            setTimer(context)
        }
    }

    /**
     * start timer to check wifi connectivity
     */
    fun setTimer(context: Context) {
        stopTimer()
        this.context = context
        this.prefeernce = PreferencesHelper(context)
        mTimer = Timer()
        mTimer!!.scheduleAtFixedRate(CheckForConnection(), 0, 5000)
    }

    /**
     * stop timer to check wifi connectivity
     */
    fun stopTimer() {
        if (mTimer != null) {
            mTimer!!.cancel()
            mTimer = null
        }
    }

    /**
     * Check for application instance is in background
     *
     * @param context activity/application context
     * @return boolean app in background
     */
    private fun isAppIsInBackground(context: Context?): Boolean {
        var isInBackground = true
        val am = context?.getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager
        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.KITKAT_WATCH) {
            if (am.runningAppProcesses != null) {
                val runningProcesses = am.runningAppProcesses
                for (processInfo in runningProcesses) {
                    if (processInfo.importance == ActivityManager.RunningAppProcessInfo.IMPORTANCE_FOREGROUND) {
                        for (activeProcess in processInfo.pkgList) {
                            if (activeProcess == context?.packageName) {
                                isInBackground = false
                            }
                        }
                    }
                }
            }
        } else {
            val taskInfo = am.getRunningTasks(1)
            val componentInfo = taskInfo[0].topActivity
            if (componentInfo.packageName == context?.packageName) {
                isInBackground = false
            }
        }

        return isInBackground
    }

    /**
     * ping to link to check wifi of mobile device have internet or not
     */
    private fun checkForGoogleLink(): Boolean {
        try {
            val urlc = URL("http://www.google.com")
                    .openConnection() as HttpURLConnection
            urlc.setRequestProperty("User-Agent", "Test")
            urlc.setRequestProperty("Connection", "close")
            urlc.connectTimeout = 1500
            urlc.connect()
            if (urlc.responseCode == 200) {
                return true
            }
        } catch (e: IOException) {
            e.printStackTrace()
        }

        return false
    }

    /**
     * ping to link to check wifi of mobile device have internet or not
     */
    private fun checkForBaiduLink(): Boolean {
        try {
            val urlc = URL("https://www.baidu.com")
                    .openConnection() as HttpURLConnection
            urlc.setRequestProperty("User-Agent", "Test")
            urlc.setRequestProperty("Connection", "close")
            urlc.connectTimeout = 1500
            urlc.connect()
            if (urlc.responseCode == 200) {
                return true
            }
        } catch (e: IOException) {
            e.printStackTrace()
        }

        return false
    }

    /**
     * ping to link to check wifi of mobile device have internet or not
     */
    private fun checkForAwsLink(): Boolean {
        try {
            val urlc = URL("https://www.amazon.com/")
                    .openConnection() as HttpURLConnection
            urlc.setRequestProperty("User-Agent", "Test")
            urlc.setRequestProperty("Connection", "close")
            urlc.connectTimeout = 1500
            urlc.connect()
            if (urlc.responseCode == 200) {
                return true
            }
        } catch (e: IOException) {
            e.printStackTrace()
        }

        return false
    }


    /**
     * Timer Task to check the Internet connectivity.
     */
    private inner class CheckForConnection : TimerTask() {
        override fun run() {
            if (!isAppIsInBackground(context)) {
                isInBackground = false
                CheckConnection(context).execute()
            } else {
                isInBackground = true
                CheckConnection(context).execute()
            }
        }
    }

    /**
     * Check for internet connection
     *
     * @param _Context activity/application context
     */
    private inner class CheckConnection(_Context: Context?) : AsyncTask<Void, Void, Boolean>(){

        private var context: Context? = null

        init {
            this.context = _Context
        }

        override fun doInBackground(vararg params: Void?): Boolean {
            var isInternet = false
            val cm = context?.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
            val wifi = cm.activeNetworkInfo
            if (wifi != null && wifi.type == ConnectivityManager.TYPE_WIFI) {
                if (checkForGoogleLink()) {
                    AppConstant.IS_INTERNET = true
                    isInternet = true
                } else if (checkForBaiduLink()){
                    AppConstant.IS_INTERNET = true
                    isInternet = true
                } else if (checkForAwsLink()){
                    AppConstant.IS_INTERNET = true
                    isInternet = true
                } else {
                    prefeernce?.savePreferences(AppConstant.SHARED_KEY_WIFI_LOST,true)
                    AppConstant.IS_INTERNET = false
                    isInternet = false
                    if(!AppConstant.IS_NETWORK_SCREEN_ON) {
                        if (!isInBackground) {
                            context?.startActivity(Intent(context, NetworkErrorActivity::class.java))
                        }
                    }

                }
                return isInternet
            } else {
                prefeernce?.savePreferences(AppConstant.SHARED_KEY_WIFI_LOST,true)
                AppConstant.IS_INTERNET = false
                isInternet = false
                if(!AppConstant.IS_NETWORK_SCREEN_ON) {
                    if (!isInBackground) {
                        context?.startActivity(Intent(context, NetworkErrorActivity::class.java))
                    }
                }
            }
            return isInternet
        }

    }
}