package com.nxp.vizncompanionapp.viewModel

import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.ViewModel
import android.content.Context
import android.net.ConnectivityManager
import android.net.wifi.ScanResult
import android.net.wifi.WifiManager
import com.nxp.vizncompanionapp.R
import com.nxp.vizncompanionapp.activities.WifiListingActivity
import com.nxp.vizncompanionapp.interfaces.SearchCallBack
import com.nxp.vizncompanionapp.utility.DisplayNotifications
import com.nxp.vizncompanionapp.utility.WifiHelper

class WiFiViewModel : ViewModel(),SearchCallBack {

    /**
     * Helper call to scan WiFi
     */
    private var mWifiHelper: WifiHelper? = null
    private var mDisplayNotifications: DisplayNotifications = DisplayNotifications()
    private var listScanResults: MutableLiveData<List<ScanResult>>? = MutableLiveData()
    private var mWifiList: MutableList<ScanResult>? = ArrayList()
    private var temp_ssid: MutableList<String>? =  ArrayList()

    override fun onNetworkDiscovered(scanResults: List<ScanResult>) {
        mDisplayNotifications?.dismissDialog()
        for (mScanResult in scanResults) {
            if (mScanResult.SSID != "") {
                if (!temp_ssid?.contains(mScanResult.SSID)!!) {
                    temp_ssid?.add(mScanResult.SSID)
                    mWifiList?.add(mScanResult)
                }
            }
        }
        listScanResults?.postValue(mWifiList)
    }

    //private var listScanResults: MutableList<ScanResult>? = null


    /**
     * this is the observer method whenever any changes done in list it will called and notify to adapter
     */
    internal fun getAllwifis(): LiveData<List<ScanResult>>? {
        return listScanResults
    }

    fun startScan(context: Context){
        if (mWifiHelper == null) {
            mWifiHelper = WifiHelper(context, true)
            mWifiHelper?.setSearchCallBack(this)
        }
        makeWiFiScan(context)
    }

    private fun makeWiFiScan(context: Context) {
        mWifiList?.clear()
        temp_ssid?.clear()
        listScanResults?.postValue(mWifiList)
        mWifiHelper?.startSearching()
        mDisplayNotifications?.fetchData(context)
    }

    fun stopScan(){
        if (mWifiHelper != null) {
            if (mWifiHelper?.isSearching()!!) {
                mWifiHelper?.stopSearching()
                mWifiHelper = null
            }
        }
    }

    fun checkWiFiConnection(context: Context,ssid: String) {
        val connManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        val wifiMgr = context.getSystemService(Context.WIFI_SERVICE) as WifiManager
        val mWifi = connManager.getNetworkInfo(ConnectivityManager.TYPE_WIFI)
        if(mWifi.isConnected){
            var name = wifiMgr.connectionInfo.ssid.replace("\"","")
            if(ssid == name){
                (context as? WifiListingActivity)?.onBackPressed();//gotoDeviceListingScreen()
            } else {
                mDisplayNotifications?.displayErrorDialog(context,context.getString(R.string.wifi_setting_msg,ssid),context.getString(R.string.settings),context.getString(R.string.cancel))
            }
        } else {
            mDisplayNotifications?.displayErrorDialog(context,context.getString(R.string.wifi_setting_msg,ssid),context.getString(R.string.settings),context.getString(R.string.cancel))
        }
    }
}