#ifndef LINSCI_H
#define LINSCI_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     linsci.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    SCI routins header file
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/****************************************************************************
 * All extern declarations of common-purpose RAM variables shall be here.
 ***************************************************************************/
/****************************************************************************
 * It require to perform zero page RAM placement optimisation.
 ***************************************************************************/


extern  LIN_BYTE LIN_TmpSCIStatus;     /* byte to clear SCI status, and to receive byte   */



/****************************************************************************/
/***                     Functions                                        ***/
/****************************************************************************/

#if !defined(LINAPI_1_0)
void LIN_SCIInit( void );
#endif /* !defined(LINAPI_1_0) */

void LIN_SCISetBaudRate( LIN_WORD baudRate );

/****************************************************************************/
/***                     Interrupt Driven routins                         ***/
/****************************************************************************/

#if !defined(LINAPI_1_0)

#endif /* !defined(LINAPI_1_0) */

/****************************************************************************/
/***                     Macros                                           ***/
/****************************************************************************/

#define    LIN_SCDRPut(data)     ( LIN_SC0DRL = (data) )

/**************************************************************************
 * Function :   LIN_SCISendZero
 *
 * Description: Send Zero byte
 *
 * Returns:     none
 *
 *              1. 9 zero bits sent
 *
 **************************************************************************/
#if defined(C32)

    /* To ommit hardware bug in PC9S12DP256 ? -- OPTIM */
#define LIN_SCISendZero()                                                                       \
            LIN_SC0CR2 &= ~LIN_SCCR2_RIE;           /* Disable SCI Rx interrupt -- for bug ?*/  \
            LIN_TmpSCIStatus = LIN_SC0SR1;          /* Read SCI status register to clear it */  \
            LIN_SCDRPut(0x00);                      /* Put zero to SCI Data Register */         \
            LIN_SC0CR2 |= LIN_SCCR2_TCIE            /* Enable SCI Tx completed interrupt */

#else /* defined(C32) */

#define LIN_SCISendZero()                                                                       \
            LIN_TmpSCIStatus = LIN_SC0SR1;          /* Read SCI status register to clear it */  \
            LIN_SCDRPut(0x00);                      /* Put zero to SCI Data Register */         \
            LIN_SC0CR2 |= LIN_SCCR2_TCIE            /* Enable SCI Tx completed interrupt */

#endif /* defined(C32) */

/**************************************************************************
 * Function :   LIN_SCISendWakeup
 *
 * Description: Send Wakeup message
 *
 * Returns:     none
 *
 * Notes:       none
 *
 **************************************************************************/
#define WAKEUP_BYTE             0x80

#if defined(C32)

    /* To ommit hardware bug in PC9S12DP256 ? -- OPTIM */
#define LIN_SCISendWakeup()                                                                     \
        LIN_SC0CR2 &= ~LIN_SCCR2_RIE;           /* Disable SCI Rx interrupt -- for bug ?*/      \
        LIN_TmpSCIStatus = LIN_SC0SR1;          /* Read SCI status register to clear it */      \
        LIN_SCDRPut(WAKEUP_BYTE);               /* Send wakeup frame */                         \
        LIN_SC0CR2 |= LIN_SCCR2_TCIE            /* Enable SCI Tx completed interrupt */

#else /* defined(C32) */

#define LIN_SCISendWakeup()                                                                     \
        LIN_TmpSCIStatus = LIN_SC0SR1;          /* Read SCI status register to clear it */      \
        LIN_SCDRPut(WAKEUP_BYTE);               /* Send wakeup frame */                         \
        LIN_SC0CR2 |= LIN_SCCR2_TCIE            /* Enable SCI Tx completed interrupt */

#endif /* defined(C32) */

#endif /* !define (LINSCI_H) */