#include <hidef.h>          /* common defines and macros */
#include <MC9S12I32.h>      /* derivative information */
#include "analog_die_reg.h"     /* analog die registers definition */
#include "linapi.h"
#include "slave_option.h"
//#include "vector.h"

typedef enum
{
  LIN_mode = 0,
  BDM_mode = 1
}tMODE;

typedef enum
{
  read = 0,
  write = 1
} FM_REGISTER_ACTION;

typedef enum
{
  done = 0,
  pending = 1
}FM_ACTION_STATUS;

typedef enum
{
  size8 = 0,
  size16 = 1
}FM_REG_SIZE;

typedef struct
{
  unsigned char *fm_address;
  unsigned char fm_data ;
  unsigned int *fm_address_16;
  unsigned int fm_data_16 ;
  FM_REGISTER_ACTION fm_read_write;
  FM_ACTION_STATUS fm_status;
  FM_REG_SIZE fm_size;
}QUEST_REGISTER;

volatile unsigned int i = 0;
volatile unsigned int j = 0;
volatile unsigned char wd = 0;
volatile unsigned int k = 0;
QUEST_REGISTER fm_register;
volatile unsigned char dummy_read;
tMODE mode = BDM_mode; // default mode is BDM
volatile unsigned char ivr = 0;
volatile unsigned char scis = 0;
volatile unsigned char LIN_enabled =0;
volatile unsigned char WD_enabled  =1;
volatile unsigned char wsr_reg = 0;


LINStatusType   ret,old_ret;
LINStatusType ret_buffer[5];
volatile unsigned char ret_index = 0;

unsigned char MsgRcvd [4];              /* received data    */

unsigned char index =0;

// function prototypes


void system_init(void);
void application_init(void);
void wait(void);
void long_wait(void);
void LIN_ISR_SCI_Interrupt(void);
// main starts here

void LIN_Command()
{

}

void main(void)
{
  system_init();
  application_init();

  LIN_Init();
  LIN_enabled = 1;
  LINR = 0x04;

  /* 1 sec. blink LS and HS LED's after reset*/
  HSCR = 3;
  LSCR = 3;
  HSR = 1;
  long_wait();
  HSCR = 0;
  LSCR = 0;
  HSR = 0;

  MMCCTL1 = 0x01;   // Enable view of flash trim locations

  bCTR0 =  TRIM0;   // Copy Trim Information to Analog Die
  bCTR1 =  TRIM1;
//bCTR2 =  TRIM2;
  bCTR2 =  0x1E;    // Max VREG-Overvoltage Threshold Trim
  bCTR3 =  TRIM3;

  bLSCEN = 0x05;    // Enable LS Control

  bLSCR = 0x03;     // Activate LS

  bHSCR = 0x03;     // Activate HS

  for(;;)
  {
  if (LIN_enabled)
  {
     // checking LIN bus
     ret = LIN_MsgStatus(0x10);
     if ((ret == LIN_OK))
        {
          ret = LIN_GetMsg(0x10, MsgRcvd ); // here 0x10 ,in the LINmaster ID = 0x50
          if (MsgRcvd[1] == 0x60)
          {
                  asm ANDCC #0x6F; // enable STOP instruction
                  MCR = 1;         // put analog die to STOP mode
                  asm STOP;        // put core to STOP mode
                  asm NOP;
                  wait(); // wait before WSR reading
                  dummy_read = WSR;
          }
          if (MsgRcvd[1] == 0x62)
          {
            MCR = 2 ; //SLEEP
          }

          ret = LIN_PutMsg( 0x15, MsgRcvd); // in the GUI ID = 0x55
        };
  }


     // checking FreeMASTER command
     if (fm_register.fm_status == pending)   // if new request from the control page
     {
        if(fm_register.fm_read_write == read) // if request for register reading
        {
         if (fm_register.fm_size == size8)
            fm_register.fm_data = *fm_register.fm_address;
         else
            fm_register.fm_data_16 = *fm_register.fm_address_16;
        }
        else       // if write to register
        {
            if ((((int) fm_register.fm_address ) == 0x216) && (fm_register.fm_data == 1)) // if STOP mode requested
               {
                 HSCR = 3;

                 wait();
                 HSCR = 0; // flash the HS diode in order to check that the program is in this section
                  fm_register.fm_address = (unsigned char *) 0x202;  // put another value to address register in order to prevent additional STOP mode entering after wake up


                  MCR = 1;  //analog die go to STOP
                  //wait();
                  asm ANDCC #$6F;
                  asm STOP;
                  wait(); // wait before WSR reading
                  dummy_read = WSR;
               }
            else
              if (((int) fm_register.fm_address) == 0x2DF)
              {
                LIN_Init();
                LIN_enabled = 1;
              }
              else
              {
              if (fm_register.fm_size == size8)
                  *fm_register.fm_address = fm_register.fm_data;
              else
                  *fm_register.fm_address_16 = fm_register.fm_data_16;
              }
        };
        fm_register.fm_status = done; // update the status flag
     };
     // WD servicing
     if (WD_enabled)
     {
       if (WDR & 0x40)
          if (wd == 1)
          {
             WDSR = 0x55;
             wd = 0;
          }
          else
            {
              WDSR = 0xAA;
              wd = 1;
            }
     }

  } /* wait forever */
}

/*----------------------------------------------------------*/

void system_init(void)
  {
//    while(!CRGFLG_LOCKST){  }; // wait until FLL locked

    // copy trim registers
/*    asm
    {
      LDD 0x4C
      STD 0x2F0
      LDD 0x4E
      STD 0xF2
    }
  */
    EnableInterrupts;
    // setting up the D2D interface
    D2DCTL0_D2DCLKDIV1 = 1;
    D2DCTL0_D2DCLKDIV0 = 1;  // D2Dclock =  bus clock divide by 4 (in order to be able to generate low PWM freq.)
    D2DCTL1 = 0x8F;    // 0b1111 timeouts can be inserted by target, ext interrupt enabled

    D2DCTL0_D2DEN = 1; // enable D2D (needed to be enabled after wrote all settings  before !!!)
    WDR |= 0b01000111;
    WDSR = 0xAA;
    wd = 1;

    //adc offset compenzation
    //ACR |= 0x20;
    //enable current measurement
    CSR = 0x80;

  }
/*----------------------------------------------------------*/
void application_init(void)
{
    fm_register.fm_read_write = read;
    fm_register.fm_status = done;
    fm_register.fm_address = 0;
    fm_register.fm_data = 0;
}

/*----------------------------------------------------------*/
void wait(void)
{
  for (i = 0; i<64510;i++)
  {
    asm NOP;
  }

}
/*----------------------------------------------------------*/
void long_wait(void)
{
  for (i = 0; i<64510;i++)
  for (k = 0; k<14; k++)
  {
    asm NOP;
  }

}
/*----------------------------------------------------------*/
#pragma TRAP_PROC

interrupt void D2D_ISR(void)
{
  ivr = IVR;  //read interrupt vector register
  if (ivr == 0)
  {
    wsr_reg = WSR; // remove interrupt flag
  }
  if (ivr == 0x16)
  {
    scis = SCIS1;
    LIN_ISR_SCI_Interrupt();
    SCIS1 = scis; //remove interrupt flag
  }

}
#pragma CODE_SEG DEFAULT         /*

----------------------------------------------------------
#pragma CODE_SEG NON_BANKED

interrupt void SPURIOUS_ISR(void)
{
  HSCR = 3;
}
#pragma CODE_SEG DEFAULT      */