#ifndef L_API_H
#define L_API_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     l_api.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN API header file for LIN Drivers
*														                            
* Description:  
*
* Notes:        
*
******************************************************************************/

/* LIN Driver data types and definitions */
#include "lindef.h"

/* LIN API data types */
typedef unsigned char	l_bool;
typedef unsigned char	l_u8;
typedef unsigned int	l_u16;
typedef unsigned char	l_irqmask;
typedef unsigned char	i_ioctl_op;

/* i_ioctl_op constant definition */
#define l_op_getrxerr   0x01        /* Provide the Receive Errors counter of the LIN Driver */
#define l_op_gettxerr   0x02        /* Provide the Transmit Errors counter of the LIN Driver */
#define l_op_clrrxerr   0x04        /* Clear the Receive Errors counter of the LIN Driver */
#define l_op_clrtxerr   0x08        /* Clear the Transmit Errors counter of the LIN Driver */
#define l_op_wakeup     0x10        /* Issues the LIN bus wakeup frame transmission */
#define l_op_getidle    0x20        /* Check "No-Bus-Activity" condition */
#define l_op_idleclock  0x40        /* Update "No-Bus-Activity" condition counter by 1 */

/* Functions declarations */
l_bool	l_sys_init( void );
void	l_ifc_init_sci0( void );
l_bool	l_ifc_connect_sci0( void );
l_bool	l_ifc_disconnect_sci0( void );
void	l_ifc_ioctl_sci0( i_ioctl_op op, void *pv );
void	l_ifc_rx_sci0( void );
#define	l_ifc_tx_sci0()     l_ifc_rx_sci0()    

/* User call-backs */
l_irqmask l_sys_irq_disable( void );
void	l_sys_irq_restore( l_irqmask previous );

#if !defined( LGENH)
//#include    "l_gen.h"
#else /* !defined( LGENH ) */
#include    LGENH
#endif /* !defined( LGENH ) */

#endif /* define (L_API_H) */
