#ifndef LINCFG_H
#define LINCFG_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lincfg.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver static configuration file for Freescale API
*														                            
* Description:  This is a template file for LIN driver configuration.
*														                            
* Notes:        
*
******************************************************************************/

/*
    This definition set the number of user-defined timer clocks
    (LIN_IdleClock service calls), recognized as "no-bus-activity" 
    condition.
    This number shall not be greater than 0xFFFF.
*/
#define LIN_IDLETIMEOUT         100u



/*
	This definition configures the LIN bus baud rate.
	This value shall be set according to target MCU 
	SCI register usage.
	MC9S12DP256: the 16-bit value will be 
    masked by 0x1FFF and put into SCI0BD register;
*/
//#define LIN_BAUDRATE			34u
  unsigned char LIN_BAUDRATE;

#if defined(MASTER)
/* 
	This definition configures the timer clock rate.
    Only for Master node.
	This value shall be set according to target MCU 
	timer prescaler register usage.
	MC9S12DP256: the 8-bit value will be 
    masked by 0x07 and put into TSCR2 register;

#define LIN_TIMERPRESCALER		3u
*/

/*
	This definition set the length of one bit transmission 
	period on the target MCU.
    Only for Master node.
	Due to 16-bit counters on target MCU this value 
	shall not be greater than 0xFFFF.
    For correct timeouts computation this value
    shall have qualificator 'l'.

#define LIN_BITTIME				52ul
*/
#endif /* defined(MASTER) */

#endif /* !define (LINCFG_H) */
