#ifndef LINDEF_H
#define LINDEF_H
/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lindef.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    LIN Driver data types and definitions.
*														                            
* Description:  
*
* Notes:        This file is NOT allowed to modify by user
*
******************************************************************************/

/*      Message direction.
        It is used for LinLookupTable.
        Bit format: abxxxxxx, where
            ab: 00 -- node ignores the message;
                01 -- node receives the message;
                10 -- node sends the message;
                11 -- node sends the message if it was updated;
            xxxxxx -- message index.                                */

#define LIN_RECEIVE         0x40u   /* node receives the message */
#define LIN_SEND            0x80u   /* node sends the message */
#define LIN_SEND_UPDATED    0xC0u   /* node sends the message if it was updated*/

/* User must not define the message if it should be ignored! */
#define LIN_IGNORE          0       /* node ignores the message */


/* Message state    */

/* The message data buffer is empty (data has not been initialized or reseived yet) */
#define LIN_MSG_NODATA      0x01u
/* The message data buffer has been updated by the user */
#define LIN_MSG_UPDATED     0x20u


/*      LIN Driver data types   */
typedef unsigned char   LINStatusType;         /* unsigned char unsigned   8  bits  */
typedef unsigned char   LINDriverStatusType;   /* unsigned char unsigned   8  bits  */
typedef unsigned char   LINMsgIdType;          /* unsigned char unsigned   8  bits  */
typedef unsigned char * LINMsgRefType;         /* unsigned char * unsigned 16 bits  */
typedef unsigned char   LINErrCounterType;     /* unsigned char unsigned   8  bits  */

/*      Types for message processing */
typedef unsigned char   LIN_MSGBUFFERTYPE;
typedef unsigned char   LIN_MSGLENGTHTYPE;

#endif /* define (LINDEF_H) */
