#ifndef LINTMR_H
#define LINTMR_H

/******************************************************************************
*                                                       
*       Copyright (C) 2005 Freescale Semiconductor, Inc.
*       All Rights Reserved								              
*														                            
* Filename:     lintmr.h                
*														                            
* Revision:      										                    
*														                            
* Functions:    Timer routins header file
*														                            
* Description:
*
* Notes:        Protocol timeouts -- only for Master node
*
******************************************************************************/


/******************************************************************************
    Idle timeout processing
******************************************************************************/
#if defined(HC12) || defined (S12)
#if defined(CW12)
#pragma DATA_SEG SHORT ZeroSeg
#endif /* defined(CW12) */
#endif /* defined(HC12)	|| defined (S12)*/

extern LIN_WORD LIN_IdleTimeout;          /* counter for idle timeout */

/* Set/reset Idle timeout */
extern void LIN_SetIdleTimeout( void );

#if defined(HC12) || defined (S12)
#if defined(CW12) 
#pragma DATA_SEG DEFAULT
#endif /* defined(CW12) */
#endif /* defined(HC12) || defined (S12)*/

#if defined(MASTER)

/******************************************************************************
    Protocol timeout processing
******************************************************************************/

/****************************************************************************/
/* Indexes for LIN_SetTimeout:                                              */

/*                              1u  - MaxFrame timeout for 1 byte message;  */
/*                              2u  - MaxFrame timeout for 2 bytes message; */
/*                              3u  - MaxFrame timeout for 3 bytes message; */
/*                              4u  - MaxFrame timeout for 4 bytes message; */
/*                              5u  - MaxFrame timeout for 5 bytes message; */
/*                              6u  - MaxFrame timeout for 6 bytes message; */
/*                              7u  - MaxFrame timeout for 7 bytes message; */
/*                              8u  - MaxFrame timeout for 8 bytes message; */

/****************************************************************************/

/******************************************************************************
    Functions
******************************************************************************/

void            LIN_SetTimeout( LIN_BYTE timeoutIndex );
void            LIN_CancelTimeout( void );

/*****************************************************************************
 *                              Macros
 *****************************************************************************/

/**************************************************************************
 * Function :   LIN_TimerInit
 *
 * Description: Timer Module Initialization
 *
 * Returns:     none
 *
 * Notes:       none
 *
 **************************************************************************/
#if defined(LINDEBUG)

#define LIN_TimerInit()                                                                         \
    /* disable timer */                                                                         \
    LIN_TSCR &= ~LIN_TM_TEN;                                                                    \
    LIN_TMSK2 &= ~LIN_TM_PR;                            /* clear prescaler */                   \
    LIN_TMSK2 |=  (LIN_TM_PR & LIN_CfgConst.LIN_TimerPrescaler);     /* set prescaler */        \
    LIN_TMSK1 &= ~LIN_TM_C0I;                           /* disable channel 0 interrupt */       \
    LIN_TIOS  |=  LIN_TM_IOS0;                          /* channel 0 performs output compare */ \
    LIN_TCTL2 &= ~(LIN_TM_OL0 | LIN_TM_OM0);            /* channel 0 is disconnect from pin logic */ \
    /* enable timer with fast flag clear ability */                                             \
    LIN_TSCR |= (LIN_TM_TEN | LIN_TM_TFFCA);                                                    \
    /* ??? TM_TSBCK: stop timer in background mode - for debug purposes */                      \
    LIN_TSCR |= 0x20

#else /* defined(LINDEBUG) */

#define LIN_TimerInit()                                                                         \
    /* disable timer */                                                                         \
    LIN_TSCR &= ~LIN_TM_TEN;                                                                    \
    LIN_TMSK2 &= ~LIN_TM_PR;                            /* clear prescaler */                   \
    LIN_TMSK2 |=  (LIN_TM_PR & LIN_CfgConst.LIN_TimerPrescaler);     /* set prescaler */        \
    LIN_TMSK1 &= ~LIN_TM_C0I;                           /* disable channel 0 interrupt */       \
    LIN_TIOS  |=  LIN_TM_IOS0;                          /* channel 0 performs output compare */ \
    LIN_TCTL2 &= ~(LIN_TM_OL0 | LIN_TM_OM0);            /* channel 0 is disconnect from pin logic */ \
    /* enable timer with fast flag clear ability */                                             \
    LIN_TSCR |= (LIN_TM_TEN | LIN_TM_TFFCA)

#endif /* defined(LINDEBUG) */

/*****************************************************************************/

#endif /* defined(MASTER) */

#endif /* !define (LINTMR_H) */
